package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.Event;
import dev.vality.swag_webhook_events.model.Invoice;
import dev.vality.swag_webhook_events.model.Payment;
import dev.vality.swag_webhook_events.model.Refund;
import dev.vality.swag_webhook_events.model.RefundCreatedAllOf;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Событие о статусе ожидания рефанда
 */
@ApiModel(description = "Событие о статусе ожидания рефанда")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-05-04T13:06:45.139911129Z[Etc/UTC]")
public class RefundPending extends Event  {
  @JsonProperty("invoice")
  private Invoice invoice;

  @JsonProperty("payment")
  private Payment payment;

  @JsonProperty("refund")
  private Refund refund;

  public RefundPending invoice(Invoice invoice) {
    this.invoice = invoice;
    return this;
  }

  /**
   * Get invoice
   * @return invoice
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public Invoice getInvoice() {
    return invoice;
  }

  public void setInvoice(Invoice invoice) {
    this.invoice = invoice;
  }

  public RefundPending payment(Payment payment) {
    this.payment = payment;
    return this;
  }

  /**
   * Get payment
   * @return payment
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public Payment getPayment() {
    return payment;
  }

  public void setPayment(Payment payment) {
    this.payment = payment;
  }

  public RefundPending refund(Refund refund) {
    this.refund = refund;
    return this;
  }

  /**
   * Get refund
   * @return refund
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public Refund getRefund() {
    return refund;
  }

  public void setRefund(Refund refund) {
    this.refund = refund;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RefundPending refundPending = (RefundPending) o;
    return Objects.equals(this.invoice, refundPending.invoice) &&
        Objects.equals(this.payment, refundPending.payment) &&
        Objects.equals(this.refund, refundPending.refund) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoice, payment, refund, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RefundPending {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    invoice: ").append(toIndentedString(invoice)).append("\n");
    sb.append("    payment: ").append(toIndentedString(payment)).append("\n");
    sb.append("    refund: ").append(toIndentedString(refund)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

