package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Родительский платеж, на основе которого создан текущий рекуррентный платеж
 */
@ApiModel(description = "Родительский платеж, на основе которого создан текущий рекуррентный платеж")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-05-04T13:06:45.139911129Z[Etc/UTC]")
public class PaymentRecurrentParent   {
  @JsonProperty("invoiceID")
  private String invoiceID;

  @JsonProperty("paymentID")
  private String paymentID;

  public PaymentRecurrentParent invoiceID(String invoiceID) {
    this.invoiceID = invoiceID;
    return this;
  }

  /**
   * Идентификатор инвойса
   * @return invoiceID
  */
  @ApiModelProperty(required = true, value = "Идентификатор инвойса")
  @NotNull


  public String getInvoiceID() {
    return invoiceID;
  }

  public void setInvoiceID(String invoiceID) {
    this.invoiceID = invoiceID;
  }

  public PaymentRecurrentParent paymentID(String paymentID) {
    this.paymentID = paymentID;
    return this;
  }

  /**
   * Идентификатор платежа
   * @return paymentID
  */
  @ApiModelProperty(required = true, value = "Идентификатор платежа")
  @NotNull


  public String getPaymentID() {
    return paymentID;
  }

  public void setPaymentID(String paymentID) {
    this.paymentID = paymentID;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentRecurrentParent paymentRecurrentParent = (PaymentRecurrentParent) o;
    return Objects.equals(this.invoiceID, paymentRecurrentParent.invoiceID) &&
        Objects.equals(this.paymentID, paymentRecurrentParent.paymentID);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceID, paymentID);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentRecurrentParent {\n");
    
    sb.append("    invoiceID: ").append(toIndentedString(invoiceID)).append("\n");
    sb.append("    paymentID: ").append(toIndentedString(paymentID)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

