package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.swag_webhook_events.model.InvoiceCartLineTaxMode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Позиция товара или услуги
 */
@ApiModel(description = "Позиция товара или услуги")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-05-04T13:06:45.139911129Z[Etc/UTC]")
public class InvoiceCartLine   {
  @JsonProperty("product")
  private String product;

  @JsonProperty("quantity")
  private Long quantity = 1l;

  @JsonProperty("price")
  private Long price;

  @JsonProperty("cost")
  private Long cost;

  @JsonProperty("taxMode")
  private InvoiceCartLineTaxMode taxMode;

  public InvoiceCartLine product(String product) {
    this.product = product;
    return this;
  }

  /**
   * Описание предлагаемого товара или услуги
   * @return product
  */
  @ApiModelProperty(required = true, value = "Описание предлагаемого товара или услуги")
  @NotNull

@Size(max = 1000) 
  public String getProduct() {
    return product;
  }

  public void setProduct(String product) {
    this.product = product;
  }

  public InvoiceCartLine quantity(Long quantity) {
    this.quantity = quantity;
    return this;
  }

  /**
   * Количество единиц товаров или услуг, предлагаемых на продажу в этой позиции 
   * minimum: 1
   * @return quantity
  */
  @ApiModelProperty(required = true, value = "Количество единиц товаров или услуг, предлагаемых на продажу в этой позиции ")
  @NotNull

@Min(1L) 
  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public InvoiceCartLine price(Long price) {
    this.price = price;
    return this;
  }

  /**
   * Цена предлагаемого товара или услуги, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты 
   * minimum: 1
   * @return price
  */
  @ApiModelProperty(required = true, value = "Цена предлагаемого товара или услуги, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты ")
  @NotNull

@Min(1L) 
  public Long getPrice() {
    return price;
  }

  public void setPrice(Long price) {
    this.price = price;
  }

  public InvoiceCartLine cost(Long cost) {
    this.cost = cost;
    return this;
  }

  /**
   * Суммарная стоимость позиции с учётом количества единиц товаров или услуг 
   * minimum: 1
   * @return cost
  */
  @ApiModelProperty(required = true, value = "Суммарная стоимость позиции с учётом количества единиц товаров или услуг ")
  @NotNull

@Min(1L) 
  public Long getCost() {
    return cost;
  }

  public void setCost(Long cost) {
    this.cost = cost;
  }

  public InvoiceCartLine taxMode(InvoiceCartLineTaxMode taxMode) {
    this.taxMode = taxMode;
    return this;
  }

  /**
   * Get taxMode
   * @return taxMode
  */
  @ApiModelProperty(value = "")

  @Valid

  public InvoiceCartLineTaxMode getTaxMode() {
    return taxMode;
  }

  public void setTaxMode(InvoiceCartLineTaxMode taxMode) {
    this.taxMode = taxMode;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceCartLine invoiceCartLine = (InvoiceCartLine) o;
    return Objects.equals(this.product, invoiceCartLine.product) &&
        Objects.equals(this.quantity, invoiceCartLine.quantity) &&
        Objects.equals(this.price, invoiceCartLine.price) &&
        Objects.equals(this.cost, invoiceCartLine.cost) &&
        Objects.equals(this.taxMode, invoiceCartLine.taxMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(product, quantity, price, cost, taxMode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceCartLine {\n");
    
    sb.append("    product: ").append(toIndentedString(product)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    cost: ").append(toIndentedString(cost)).append("\n");
    sb.append("    taxMode: ").append(toIndentedString(taxMode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

