package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.InvoiceCartLine;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Данные инвойса
 */
@ApiModel(description = "Данные инвойса")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-05-04T13:06:45.139911129Z[Etc/UTC]")
public class Invoice   {
  @JsonProperty("id")
  private String id;

  @JsonProperty("shopID")
  private String shopID;

  @JsonProperty("createdAt")
  @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdAt;

  /**
   * Статус инвойса
   */
  public enum StatusEnum {
    UNPAID("unpaid"),
    
    CANCELLED("cancelled"),
    
    PAID("paid"),
    
    REFUNDED("refunded"),
    
    FULFILLED("fulfilled");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("status")
  private StatusEnum status;

  @JsonProperty("reason")
  private String reason;

  @JsonProperty("dueDate")
  @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime dueDate;

  @JsonProperty("amount")
  private Long amount;

  @JsonProperty("currency")
  private String currency;

  @JsonProperty("metadata")
  private Object metadata;

  @JsonProperty("product")
  private String product;

  @JsonProperty("description")
  private String description;

  @JsonProperty("cart")
  @Valid
  private List<InvoiceCartLine> cart = null;

  @JsonProperty("externalId")
  private String externalId;

  public Invoice id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Идентификатор инвойса
   * @return id
  */
  @ApiModelProperty(required = true, value = "Идентификатор инвойса")
  @NotNull


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Invoice shopID(String shopID) {
    this.shopID = shopID;
    return this;
  }

  /**
   * Идентификатор магазина
   * @return shopID
  */
  @ApiModelProperty(required = true, value = "Идентификатор магазина")
  @NotNull


  public String getShopID() {
    return shopID;
  }

  public void setShopID(String shopID) {
    this.shopID = shopID;
  }

  public Invoice createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Дата и время создания
   * @return createdAt
  */
  @ApiModelProperty(required = true, value = "Дата и время создания")
  @NotNull

  @Valid

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public Invoice status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * Статус инвойса
   * @return status
  */
  @ApiModelProperty(required = true, value = "Статус инвойса")
  @NotNull


  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public Invoice reason(String reason) {
    this.reason = reason;
    return this;
  }

  /**
   * Причина отмены или погашения инвойса
   * @return reason
  */
  @ApiModelProperty(value = "Причина отмены или погашения инвойса")


  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }

  public Invoice dueDate(OffsetDateTime dueDate) {
    this.dueDate = dueDate;
    return this;
  }

  /**
   * Дата и время истечения срока жизни
   * @return dueDate
  */
  @ApiModelProperty(required = true, value = "Дата и время истечения срока жизни")
  @NotNull

  @Valid

  public OffsetDateTime getDueDate() {
    return dueDate;
  }

  public void setDueDate(OffsetDateTime dueDate) {
    this.dueDate = dueDate;
  }

  public Invoice amount(Long amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Стоимость предлагаемых товаров или услуг, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. 
   * minimum: 1
   * @return amount
  */
  @ApiModelProperty(required = true, value = "Стоимость предлагаемых товаров или услуг, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. ")
  @NotNull

@Min(1L) 
  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public Invoice currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Валюта, символьный код согласно [RFC 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). 
   * @return currency
  */
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [RFC 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). ")
  @NotNull


  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public Invoice metadata(Object metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Связанные с инвойсом метаданные
   * @return metadata
  */
  @ApiModelProperty(required = true, value = "Связанные с инвойсом метаданные")
  @NotNull


  public Object getMetadata() {
    return metadata;
  }

  public void setMetadata(Object metadata) {
    this.metadata = metadata;
  }

  public Invoice product(String product) {
    this.product = product;
    return this;
  }

  /**
   * Наименование предлагаемых товаров или услуг
   * @return product
  */
  @ApiModelProperty(required = true, value = "Наименование предлагаемых товаров или услуг")
  @NotNull


  public String getProduct() {
    return product;
  }

  public void setProduct(String product) {
    this.product = product;
  }

  public Invoice description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Описание предлагаемых товаров или услуг
   * @return description
  */
  @ApiModelProperty(value = "Описание предлагаемых товаров или услуг")


  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Invoice cart(List<InvoiceCartLine> cart) {
    this.cart = cart;
    return this;
  }

  public Invoice addCartItem(InvoiceCartLine cartItem) {
    if (this.cart == null) {
      this.cart = new ArrayList<>();
    }
    this.cart.add(cartItem);
    return this;
  }

  /**
   * Корзина с набором позиций продаваемых товаров или услуг 
   * @return cart
  */
  @ApiModelProperty(value = "Корзина с набором позиций продаваемых товаров или услуг ")

  @Valid
@Size(min = 1, max = 100) 
  public List<InvoiceCartLine> getCart() {
    return cart;
  }

  public void setCart(List<InvoiceCartLine> cart) {
    this.cart = cart;
  }

  public Invoice externalId(String externalId) {
    this.externalId = externalId;
    return this;
  }

  /**
   * Идентификатор транзакции со стороны мерчанта
   * @return externalId
  */
  @ApiModelProperty(value = "Идентификатор транзакции со стороны мерчанта")


  public String getExternalId() {
    return externalId;
  }

  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Invoice invoice = (Invoice) o;
    return Objects.equals(this.id, invoice.id) &&
        Objects.equals(this.shopID, invoice.shopID) &&
        Objects.equals(this.createdAt, invoice.createdAt) &&
        Objects.equals(this.status, invoice.status) &&
        Objects.equals(this.reason, invoice.reason) &&
        Objects.equals(this.dueDate, invoice.dueDate) &&
        Objects.equals(this.amount, invoice.amount) &&
        Objects.equals(this.currency, invoice.currency) &&
        Objects.equals(this.metadata, invoice.metadata) &&
        Objects.equals(this.product, invoice.product) &&
        Objects.equals(this.description, invoice.description) &&
        Objects.equals(this.cart, invoice.cart) &&
        Objects.equals(this.externalId, invoice.externalId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, shopID, createdAt, status, reason, dueDate, amount, currency, metadata, product, description, cart, externalId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Invoice {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    shopID: ").append(toIndentedString(shopID)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    dueDate: ").append(toIndentedString(dueDate)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    product: ").append(toIndentedString(product)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    cart: ").append(toIndentedString(cart)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

