package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * DigitalWalletDetailsQIWIAllOf
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-05-04T13:06:45.139911129Z[Etc/UTC]")
public class DigitalWalletDetailsQIWIAllOf   {
  @JsonProperty("phoneNumberMask")
  private String phoneNumberMask;

  public DigitalWalletDetailsQIWIAllOf phoneNumberMask(String phoneNumberMask) {
    this.phoneNumberMask = phoneNumberMask;
    return this;
  }

  /**
   * Маскированный номер телефона плательщика в международном формате, выступающий в роли идентификатора кошелька Visa QIWI Wallet. 
   * @return phoneNumberMask
  */
  @ApiModelProperty(example = "+7******3210", required = true, value = "Маскированный номер телефона плательщика в международном формате, выступающий в роли идентификатора кошелька Visa QIWI Wallet. ")
  @NotNull

@Pattern(regexp = "^\\+\\d\\*{1,10}\\d{2,4}$") 
  public String getPhoneNumberMask() {
    return phoneNumberMask;
  }

  public void setPhoneNumberMask(String phoneNumberMask) {
    this.phoneNumberMask = phoneNumberMask;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DigitalWalletDetailsQIWIAllOf digitalWalletDetailsQIWIAllOf = (DigitalWalletDetailsQIWIAllOf) o;
    return Objects.equals(this.phoneNumberMask, digitalWalletDetailsQIWIAllOf.phoneNumberMask);
  }

  @Override
  public int hashCode() {
    return Objects.hash(phoneNumberMask);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DigitalWalletDetailsQIWIAllOf {\n");
    
    sb.append("    phoneNumberMask: ").append(toIndentedString(phoneNumberMask)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

