package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.Customer;
import dev.vality.swag_webhook_events.model.CustomerBinding;
import dev.vality.swag_webhook_events.model.CustomerBindingStartedAllOf;
import dev.vality.swag_webhook_events.model.Event;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Событие об успешной привязке плательщика к платежному средству
 */
@ApiModel(description = "Событие об успешной привязке плательщика к платежному средству")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-05-04T13:06:45.139911129Z[Etc/UTC]")
public class CustomerBindingSucceeded extends Event  {
  @JsonProperty("customer")
  private Customer customer;

  @JsonProperty("binding")
  private CustomerBinding binding;

  public CustomerBindingSucceeded customer(Customer customer) {
    this.customer = customer;
    return this;
  }

  /**
   * Get customer
   * @return customer
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public Customer getCustomer() {
    return customer;
  }

  public void setCustomer(Customer customer) {
    this.customer = customer;
  }

  public CustomerBindingSucceeded binding(CustomerBinding binding) {
    this.binding = binding;
    return this;
  }

  /**
   * Get binding
   * @return binding
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public CustomerBinding getBinding() {
    return binding;
  }

  public void setBinding(CustomerBinding binding) {
    this.binding = binding;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CustomerBindingSucceeded customerBindingSucceeded = (CustomerBindingSucceeded) o;
    return Objects.equals(this.customer, customerBindingSucceeded.customer) &&
        Objects.equals(this.binding, customerBindingSucceeded.binding) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customer, binding, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CustomerBindingSucceeded {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    customer: ").append(toIndentedString(customer)).append("\n");
    sb.append("    binding: ").append(toIndentedString(binding)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

