package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * BankCardDetails
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-02-21T10:48:07.789932288Z[Etc/UTC]")
public class BankCardDetails   {
  @JsonProperty("bin")
  private String bin;

  @JsonProperty("lastDigits")
  private String lastDigits;

  @JsonProperty("cardNumberMask")
  private String cardNumberMask;

  @JsonProperty("paymentSystem")
  private String paymentSystem;

  /**
   * Провайдер платежных токенов
   */
  public enum TokenProviderEnum {
    APPLEPAY("applepay"),
    
    GOOGLEPAY("googlepay"),
    
    SAMSUNGPAY("samsungpay"),
    
    YANDEXPAY("yandexpay");

    private String value;

    TokenProviderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TokenProviderEnum fromValue(String value) {
      for (TokenProviderEnum b : TokenProviderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("tokenProvider")
  private TokenProviderEnum tokenProvider;

  @JsonProperty("issuerCountry")
  private String issuerCountry;

  @JsonProperty("bankName")
  private String bankName;

  public BankCardDetails bin(String bin) {
    this.bin = bin;
    return this;
  }

  /**
   * БИН банка-эмитента карты
   * @return bin
  */
  @ApiModelProperty(required = true, value = "БИН банка-эмитента карты")
  @NotNull

@Pattern(regexp = "^\\d{6,8}$") 
  public String getBin() {
    return bin;
  }

  public void setBin(String bin) {
    this.bin = bin;
  }

  public BankCardDetails lastDigits(String lastDigits) {
    this.lastDigits = lastDigits;
    return this;
  }

  /**
   * Последние цифры номера карты
   * @return lastDigits
  */
  @ApiModelProperty(required = true, value = "Последние цифры номера карты")
  @NotNull

@Pattern(regexp = "^\\d{2,4}$") 
  public String getLastDigits() {
    return lastDigits;
  }

  public void setLastDigits(String lastDigits) {
    this.lastDigits = lastDigits;
  }

  public BankCardDetails cardNumberMask(String cardNumberMask) {
    this.cardNumberMask = cardNumberMask;
    return this;
  }

  /**
   * Маскированый номер карты
   * @return cardNumberMask
  */
  @ApiModelProperty(required = true, value = "Маскированый номер карты")
  @NotNull

@Pattern(regexp = "^\\d{6,8}\\*+\\d{2,4}$") 
  public String getCardNumberMask() {
    return cardNumberMask;
  }

  public void setCardNumberMask(String cardNumberMask) {
    this.cardNumberMask = cardNumberMask;
  }

  public BankCardDetails paymentSystem(String paymentSystem) {
    this.paymentSystem = paymentSystem;
    return this;
  }

  /**
   * Платежная система
   * @return paymentSystem
  */
  @ApiModelProperty(required = true, value = "Платежная система")
  @NotNull

@Size(max = 100) 
  public String getPaymentSystem() {
    return paymentSystem;
  }

  public void setPaymentSystem(String paymentSystem) {
    this.paymentSystem = paymentSystem;
  }

  public BankCardDetails tokenProvider(TokenProviderEnum tokenProvider) {
    this.tokenProvider = tokenProvider;
    return this;
  }

  /**
   * Провайдер платежных токенов
   * @return tokenProvider
  */
  @ApiModelProperty(value = "Провайдер платежных токенов")


  public TokenProviderEnum getTokenProvider() {
    return tokenProvider;
  }

  public void setTokenProvider(TokenProviderEnum tokenProvider) {
    this.tokenProvider = tokenProvider;
  }

  public BankCardDetails issuerCountry(String issuerCountry) {
    this.issuerCountry = issuerCountry;
    return this;
  }

  /**
   * Страна эмитент (alpha-3 код по стандарту ISO_3166-1)
   * @return issuerCountry
  */
  @ApiModelProperty(example = "[\"RUS\",\"POL\",\"USA\"]", value = "Страна эмитент (alpha-3 код по стандарту ISO_3166-1)")


  public String getIssuerCountry() {
    return issuerCountry;
  }

  public void setIssuerCountry(String issuerCountry) {
    this.issuerCountry = issuerCountry;
  }

  public BankCardDetails bankName(String bankName) {
    this.bankName = bankName;
    return this;
  }

  /**
   * Наименование банка
   * @return bankName
  */
  @ApiModelProperty(example = "[\"SBERBANK OF RUSSIA\",\"JOINT STOCK COMPANY ALFA-BANK\",\"VTB BANK OJSC\"]", value = "Наименование банка")


  public String getBankName() {
    return bankName;
  }

  public void setBankName(String bankName) {
    this.bankName = bankName;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BankCardDetails bankCardDetails = (BankCardDetails) o;
    return Objects.equals(this.bin, bankCardDetails.bin) &&
        Objects.equals(this.lastDigits, bankCardDetails.lastDigits) &&
        Objects.equals(this.cardNumberMask, bankCardDetails.cardNumberMask) &&
        Objects.equals(this.paymentSystem, bankCardDetails.paymentSystem) &&
        Objects.equals(this.tokenProvider, bankCardDetails.tokenProvider) &&
        Objects.equals(this.issuerCountry, bankCardDetails.issuerCountry) &&
        Objects.equals(this.bankName, bankCardDetails.bankName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bin, lastDigits, cardNumberMask, paymentSystem, tokenProvider, issuerCountry, bankName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BankCardDetails {\n");
    
    sb.append("    bin: ").append(toIndentedString(bin)).append("\n");
    sb.append("    lastDigits: ").append(toIndentedString(lastDigits)).append("\n");
    sb.append("    cardNumberMask: ").append(toIndentedString(cardNumberMask)).append("\n");
    sb.append("    paymentSystem: ").append(toIndentedString(paymentSystem)).append("\n");
    sb.append("    tokenProvider: ").append(toIndentedString(tokenProvider)).append("\n");
    sb.append("    issuerCountry: ").append(toIndentedString(issuerCountry)).append("\n");
    sb.append("    bankName: ").append(toIndentedString(bankName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

