package dev.vality.swag_webhook_events.api;

import dev.vality.swag_webhook_events.model.Event;
import dev.vality.swag_webhook_events.model.GeneralError;
import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * A delegate to be called by the {@link WebhookApiController}}.
 * Implement this interface with a {@link org.springframework.stereotype.Service} annotated class.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-02-21T10:48:07.789932288Z[Etc/UTC]")
public interface WebhookApiDelegate {

    default Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    /**
     * POST /webhook : Оповестить о событии
     *
     * @param contentSignature Подпись сообщения, сформированная согласно указанным выше правилам  (required)
     * @param event Данные произошедшего в платформе события (required)
     * @return Оповещение обработано (status code 200)
     *         or Заданный ресурс не найден (status code 404)
     * @see WebhookApi#notifyWebhookEvent
     */
    default ResponseEntity<Void> notifyWebhookEvent(String contentSignature,
        Event event) {
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

}
