/*
 * Vality Webhooks Events API
 *  ## Webhooks Events API  Данная спецификация определяет протокол доставки оповещений о возникновении новых событий в рамках вашей организации, которые платформа доставляет в виде HTTP-запросов на URL-адреса созданных вами webhook'ов. Обработчики для подобного рода запросов необходимо реализовать на стороне вашего серверного кода согласно данной спецификации.  Webhook — это подписка на определенный тип события либо их группу, касающихся различных объектов в рамках вашей организации. Для управления webhook'ами используются методы Vality API, описанные в спецификации [Vality Webhooks Management API](https://vality.github.io/api#Webhooks). Когда наступает одно из событий в рамках определенного инвойса (например, изменение статуса инвойса или платежа по этому инвойсу), платформа выбирает webhook, подходящий под этот тип события, и отправляет HTTP-запрос, содержащий сообщение в формате JSON на указанный в этом webhook'е URL. Если вы создали несколько webhook'ов, подходящих под этот тип события, то событие доставляется одновременно на все заданные в них URL в неопределённом порядке.  ## Стратегия доставки  Платформа гарантирует порядок доставки событий в рамках определенного инвойса, никакое событие не может быть пропущено и доставлено не в порядке возникновения в платформе. Платформа поддерживает очередь сообщений для каждого инвойса для того, чтобы соблюсти эти гарантии.  Запрос на доставку считается успешным только при получении ответа со статусом `200`. Платформа будет ожидать успешного ответа на отправленный запрос в течение 10 секунд. В случае ответа любым другим статусом или по истечении указанного времени, отведённого на обработку оповещения, платформа будет пытаться повторно доставить оповещения до получения успешного ответа, либо до принятия решения о невозможности доставить информацию. Попытки доставки будут производиться со следующими временными интервалами между запросами:    - 30 секунд,   - 5 минут,   - 15 минут,   - 1 час.   - каждый час в течение суток (24 часа)  Если последняя попытка доставить оповещение оканчивается неудачей, все события, которые накопились в очереди этого инвойса, отбрасываются.  ## Авторизация полученных сообщений  Платформа подтверждает подлинность оповещений, подписывая сообщения приватным ключом, уникальным для каждого webhook'а, парный публичный ключ к которому содержится в данных этого webhook'а. Подпись передается в HTTP-заголовке `Content-Signature`. В заголовке в виде различных атрибутов содержится информация об использованном при формировании подписи алгоритме и значение подписи в формате [URL-safe base-64](https://tools.ietf.org/html/rfc4648).  ``` Content-Signature: alg=RS256; digest=zFuf7bRH4RHwyktaqHQwmX5rn3LfSb4dKo... ```  На данный момент возможно использование единственного алоритма формирования подписи.  ### [RS256](https://tools.ietf.org/html/rfc7518#section-3.3)  Подпись формируется согласно алгоритму [RSASSA-PKCS1-v1_5](https://tools.ietf.org/html/rfc3447#section-8.2), на вход которому подаётся результат вычисления хэша сообщения по алгоритму [SHA-256](https://tools.ietf.org/html/rfc6234).  Набор атрибутов заголовка и список возможных алгоритмов формирования подписи в дальнейшем могут быть расширены. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@vality.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package dev.vality.swag_webhook_events.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.Payer;
import dev.vality.swag_webhook_events.model.PaymentContactInfo;
import dev.vality.swag_webhook_events.model.PaymentError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Данные платежа в рамках инвойса
 */
@ApiModel(description = "Данные платежа в рамках инвойса")
@JsonPropertyOrder({
  Payment.JSON_PROPERTY_ID,
  Payment.JSON_PROPERTY_CREATED_AT,
  Payment.JSON_PROPERTY_STATUS,
  Payment.JSON_PROPERTY_ERROR,
  Payment.JSON_PROPERTY_AMOUNT,
  Payment.JSON_PROPERTY_CURRENCY,
  Payment.JSON_PROPERTY_METADATA,
  Payment.JSON_PROPERTY_PAYMENT_TOOL_TOKEN,
  Payment.JSON_PROPERTY_PAYMENT_SESSION,
  Payment.JSON_PROPERTY_CONTACT_INFO,
  Payment.JSON_PROPERTY_IP,
  Payment.JSON_PROPERTY_FINGERPRINT,
  Payment.JSON_PROPERTY_PAYER,
  Payment.JSON_PROPERTY_FEE,
  Payment.JSON_PROPERTY_RRN
})
@JsonTypeName("Payment")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-02-21T10:48:08.381944838Z[Etc/UTC]")
public class Payment {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  /**
   * Статус платежа
   */
  public enum StatusEnum {
    PENDING("pending"),
    
    PROCESSED("processed"),
    
    CAPTURED("captured"),
    
    CANCELLED("cancelled"),
    
    REFUNDED("refunded"),
    
    FAILED("failed");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_ERROR = "error";
  private PaymentError error;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Long amount;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Object metadata;

  public static final String JSON_PROPERTY_PAYMENT_TOOL_TOKEN = "paymentToolToken";
  private String paymentToolToken;

  public static final String JSON_PROPERTY_PAYMENT_SESSION = "paymentSession";
  private String paymentSession;

  public static final String JSON_PROPERTY_CONTACT_INFO = "contactInfo";
  private PaymentContactInfo contactInfo;

  public static final String JSON_PROPERTY_IP = "ip";
  private String ip;

  public static final String JSON_PROPERTY_FINGERPRINT = "fingerprint";
  private String fingerprint;

  public static final String JSON_PROPERTY_PAYER = "payer";
  private Payer payer;

  public static final String JSON_PROPERTY_FEE = "fee";
  private Long fee;

  public static final String JSON_PROPERTY_RRN = "rrn";
  private String rrn;

  public Payment() { 
  }

  public Payment id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Идентификатор платежа
   * @return id
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Идентификатор платежа")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public Payment createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Дата и время создания
   * @return createdAt
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Дата и время создания")
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public Payment status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Статус платежа
   * @return status
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Статус платежа")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public Payment error(PaymentError error) {
    
    this.error = error;
    return this;
  }

   /**
   * Get error
   * @return error
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ERROR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PaymentError getError() {
    return error;
  }


  @JsonProperty(JSON_PROPERTY_ERROR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setError(PaymentError error) {
    this.error = error;
  }


  public Payment amount(Long amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Стоимость предлагаемых товаров или услуг, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. 
   * minimum: 1
   * @return amount
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Стоимость предлагаемых товаров или услуг, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. ")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmount(Long amount) {
    this.amount = amount;
  }


  public Payment currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Валюта, символьный код согласно [RFC 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). 
   * @return currency
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [RFC 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). ")
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public Payment metadata(Object metadata) {
    
    this.metadata = metadata;
    return this;
  }

   /**
   * Связанные с платежом метаданные
   * @return metadata
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Связанные с платежом метаданные")
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Object metadata) {
    this.metadata = metadata;
  }


  public Payment paymentToolToken(String paymentToolToken) {
    
    this.paymentToolToken = paymentToolToken;
    return this;
  }

   /**
   * **Deprecated.** _Используйте свойство &#x60;payer&#x60;._ Токен платежного средства, предоставленного плательщиком 
   * @return paymentToolToken
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "**Deprecated.** _Используйте свойство `payer`._ Токен платежного средства, предоставленного плательщиком ")
  @JsonProperty(JSON_PROPERTY_PAYMENT_TOOL_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentToolToken() {
    return paymentToolToken;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_TOOL_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentToolToken(String paymentToolToken) {
    this.paymentToolToken = paymentToolToken;
  }


  public Payment paymentSession(String paymentSession) {
    
    this.paymentSession = paymentSession;
    return this;
  }

   /**
   * **Deprecated.** _Используйте свойство &#x60;payer&#x60;._ Идентификатор платежной сессии 
   * @return paymentSession
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "**Deprecated.** _Используйте свойство `payer`._ Идентификатор платежной сессии ")
  @JsonProperty(JSON_PROPERTY_PAYMENT_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPaymentSession() {
    return paymentSession;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPaymentSession(String paymentSession) {
    this.paymentSession = paymentSession;
  }


  public Payment contactInfo(PaymentContactInfo contactInfo) {
    
    this.contactInfo = contactInfo;
    return this;
  }

   /**
   * Get contactInfo
   * @return contactInfo
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CONTACT_INFO)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PaymentContactInfo getContactInfo() {
    return contactInfo;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_INFO)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContactInfo(PaymentContactInfo contactInfo) {
    this.contactInfo = contactInfo;
  }


  public Payment ip(String ip) {
    
    this.ip = ip;
    return this;
  }

   /**
   * **Deprecated.** _Используйте свойство &#x60;payer&#x60;._ IP-адрес плательщика 
   * @return ip
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "**Deprecated.** _Используйте свойство `payer`._ IP-адрес плательщика ")
  @JsonProperty(JSON_PROPERTY_IP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIp() {
    return ip;
  }


  @JsonProperty(JSON_PROPERTY_IP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIp(String ip) {
    this.ip = ip;
  }


  public Payment fingerprint(String fingerprint) {
    
    this.fingerprint = fingerprint;
    return this;
  }

   /**
   * **Deprecated.** _Используйте свойство &#x60;payer&#x60;._ Уникальный отпечаток user agent&#39;а плательщика 
   * @return fingerprint
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "**Deprecated.** _Используйте свойство `payer`._ Уникальный отпечаток user agent'а плательщика ")
  @JsonProperty(JSON_PROPERTY_FINGERPRINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFingerprint() {
    return fingerprint;
  }


  @JsonProperty(JSON_PROPERTY_FINGERPRINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFingerprint(String fingerprint) {
    this.fingerprint = fingerprint;
  }


  public Payment payer(Payer payer) {
    
    this.payer = payer;
    return this;
  }

   /**
   * Get payer
   * @return payer
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PAYER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Payer getPayer() {
    return payer;
  }


  @JsonProperty(JSON_PROPERTY_PAYER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPayer(Payer payer) {
    this.payer = payer;
  }


  public Payment fee(Long fee) {
    
    this.fee = fee;
    return this;
  }

   /**
   * Комиссия системы, в минорных денежных единицах. 
   * @return fee
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Комиссия системы, в минорных денежных единицах. ")
  @JsonProperty(JSON_PROPERTY_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getFee() {
    return fee;
  }


  @JsonProperty(JSON_PROPERTY_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFee(Long fee) {
    this.fee = fee;
  }


  public Payment rrn(String rrn) {
    
    this.rrn = rrn;
    return this;
  }

   /**
   * Уникальный номер транзакции в системе авторизации и расчетов обслуживающего банка 
   * @return rrn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Уникальный номер транзакции в системе авторизации и расчетов обслуживающего банка ")
  @JsonProperty(JSON_PROPERTY_RRN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRrn() {
    return rrn;
  }


  @JsonProperty(JSON_PROPERTY_RRN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRrn(String rrn) {
    this.rrn = rrn;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Payment payment = (Payment) o;
    return Objects.equals(this.id, payment.id) &&
        Objects.equals(this.createdAt, payment.createdAt) &&
        Objects.equals(this.status, payment.status) &&
        Objects.equals(this.error, payment.error) &&
        Objects.equals(this.amount, payment.amount) &&
        Objects.equals(this.currency, payment.currency) &&
        Objects.equals(this.metadata, payment.metadata) &&
        Objects.equals(this.paymentToolToken, payment.paymentToolToken) &&
        Objects.equals(this.paymentSession, payment.paymentSession) &&
        Objects.equals(this.contactInfo, payment.contactInfo) &&
        Objects.equals(this.ip, payment.ip) &&
        Objects.equals(this.fingerprint, payment.fingerprint) &&
        Objects.equals(this.payer, payment.payer) &&
        Objects.equals(this.fee, payment.fee) &&
        Objects.equals(this.rrn, payment.rrn);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdAt, status, error, amount, currency, metadata, paymentToolToken, paymentSession, contactInfo, ip, fingerprint, payer, fee, rrn);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Payment {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    paymentToolToken: ").append(toIndentedString(paymentToolToken)).append("\n");
    sb.append("    paymentSession: ").append(toIndentedString(paymentSession)).append("\n");
    sb.append("    contactInfo: ").append(toIndentedString(contactInfo)).append("\n");
    sb.append("    ip: ").append(toIndentedString(ip)).append("\n");
    sb.append("    fingerprint: ").append(toIndentedString(fingerprint)).append("\n");
    sb.append("    payer: ").append(toIndentedString(payer)).append("\n");
    sb.append("    fee: ").append(toIndentedString(fee)).append("\n");
    sb.append("    rrn: ").append(toIndentedString(rrn)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

