/*
 * Vality Webhooks Events API
 *  ## Webhooks Events API  Данная спецификация определяет протокол доставки оповещений о возникновении новых событий в рамках вашей организации, которые платформа доставляет в виде HTTP-запросов на URL-адреса созданных вами webhook'ов. Обработчики для подобного рода запросов необходимо реализовать на стороне вашего серверного кода согласно данной спецификации.  Webhook — это подписка на определенный тип события либо их группу, касающихся различных объектов в рамках вашей организации. Для управления webhook'ами используются методы Vality API, описанные в спецификации [Vality Webhooks Management API](https://vality.github.io/api#Webhooks). Когда наступает одно из событий в рамках определенного инвойса (например, изменение статуса инвойса или платежа по этому инвойсу), платформа выбирает webhook, подходящий под этот тип события, и отправляет HTTP-запрос, содержащий сообщение в формате JSON на указанный в этом webhook'е URL. Если вы создали несколько webhook'ов, подходящих под этот тип события, то событие доставляется одновременно на все заданные в них URL в неопределённом порядке.  ## Стратегия доставки  Платформа гарантирует порядок доставки событий в рамках определенного инвойса, никакое событие не может быть пропущено и доставлено не в порядке возникновения в платформе. Платформа поддерживает очередь сообщений для каждого инвойса для того, чтобы соблюсти эти гарантии.  Запрос на доставку считается успешным только при получении ответа со статусом `200`. Платформа будет ожидать успешного ответа на отправленный запрос в течение 10 секунд. В случае ответа любым другим статусом или по истечении указанного времени, отведённого на обработку оповещения, платформа будет пытаться повторно доставить оповещения до получения успешного ответа, либо до принятия решения о невозможности доставить информацию. Попытки доставки будут производиться со следующими временными интервалами между запросами:    - 30 секунд,   - 5 минут,   - 15 минут,   - 1 час.   - каждый час в течение суток (24 часа)  Если последняя попытка доставить оповещение оканчивается неудачей, все события, которые накопились в очереди этого инвойса, отбрасываются.  ## Авторизация полученных сообщений  Платформа подтверждает подлинность оповещений, подписывая сообщения приватным ключом, уникальным для каждого webhook'а, парный публичный ключ к которому содержится в данных этого webhook'а. Подпись передается в HTTP-заголовке `Content-Signature`. В заголовке в виде различных атрибутов содержится информация об использованном при формировании подписи алгоритме и значение подписи в формате [URL-safe base-64](https://tools.ietf.org/html/rfc4648).  ``` Content-Signature: alg=RS256; digest=zFuf7bRH4RHwyktaqHQwmX5rn3LfSb4dKo... ```  На данный момент возможно использование единственного алоритма формирования подписи.  ### [RS256](https://tools.ietf.org/html/rfc7518#section-3.3)  Подпись формируется согласно алгоритму [RSASSA-PKCS1-v1_5](https://tools.ietf.org/html/rfc3447#section-8.2), на вход которому подаётся результат вычисления хэша сообщения по алгоритму [SHA-256](https://tools.ietf.org/html/rfc6234).  Набор атрибутов заголовка и список возможных алгоритмов формирования подписи в дальнейшем могут быть расширены. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@vality.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package dev.vality.swag_webhook_events.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.InvoiceCartLineTaxMode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Позиция товара или услуги
 */
@ApiModel(description = "Позиция товара или услуги")
@JsonPropertyOrder({
  InvoiceCartLine.JSON_PROPERTY_PRODUCT,
  InvoiceCartLine.JSON_PROPERTY_QUANTITY,
  InvoiceCartLine.JSON_PROPERTY_PRICE,
  InvoiceCartLine.JSON_PROPERTY_COST,
  InvoiceCartLine.JSON_PROPERTY_TAX_MODE
})
@JsonTypeName("InvoiceCartLine")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-02-21T10:48:08.381944838Z[Etc/UTC]")
public class InvoiceCartLine {
  public static final String JSON_PROPERTY_PRODUCT = "product";
  private String product;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Long quantity = 1l;

  public static final String JSON_PROPERTY_PRICE = "price";
  private Long price;

  public static final String JSON_PROPERTY_COST = "cost";
  private Long cost;

  public static final String JSON_PROPERTY_TAX_MODE = "taxMode";
  private InvoiceCartLineTaxMode taxMode;

  public InvoiceCartLine() { 
  }

  public InvoiceCartLine product(String product) {
    
    this.product = product;
    return this;
  }

   /**
   * Описание предлагаемого товара или услуги
   * @return product
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Описание предлагаемого товара или услуги")
  @JsonProperty(JSON_PROPERTY_PRODUCT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getProduct() {
    return product;
  }


  @JsonProperty(JSON_PROPERTY_PRODUCT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProduct(String product) {
    this.product = product;
  }


  public InvoiceCartLine quantity(Long quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * Количество единиц товаров или услуг, предлагаемых на продажу в этой позиции 
   * minimum: 1
   * @return quantity
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Количество единиц товаров или услуг, предлагаемых на продажу в этой позиции ")
  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }


  public InvoiceCartLine price(Long price) {
    
    this.price = price;
    return this;
  }

   /**
   * Цена предлагаемого товара или услуги, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты 
   * minimum: 1
   * @return price
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Цена предлагаемого товара или услуги, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты ")
  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPrice(Long price) {
    this.price = price;
  }


  public InvoiceCartLine cost(Long cost) {
    
    this.cost = cost;
    return this;
  }

   /**
   * Суммарная стоимость позиции с учётом количества единиц товаров или услуг 
   * minimum: 1
   * @return cost
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Суммарная стоимость позиции с учётом количества единиц товаров или услуг ")
  @JsonProperty(JSON_PROPERTY_COST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getCost() {
    return cost;
  }


  @JsonProperty(JSON_PROPERTY_COST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCost(Long cost) {
    this.cost = cost;
  }


  public InvoiceCartLine taxMode(InvoiceCartLineTaxMode taxMode) {
    
    this.taxMode = taxMode;
    return this;
  }

   /**
   * Get taxMode
   * @return taxMode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TAX_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public InvoiceCartLineTaxMode getTaxMode() {
    return taxMode;
  }


  @JsonProperty(JSON_PROPERTY_TAX_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTaxMode(InvoiceCartLineTaxMode taxMode) {
    this.taxMode = taxMode;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceCartLine invoiceCartLine = (InvoiceCartLine) o;
    return Objects.equals(this.product, invoiceCartLine.product) &&
        Objects.equals(this.quantity, invoiceCartLine.quantity) &&
        Objects.equals(this.price, invoiceCartLine.price) &&
        Objects.equals(this.cost, invoiceCartLine.cost) &&
        Objects.equals(this.taxMode, invoiceCartLine.taxMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(product, quantity, price, cost, taxMode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceCartLine {\n");
    sb.append("    product: ").append(toIndentedString(product)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    cost: ").append(toIndentedString(cost)).append("\n");
    sb.append("    taxMode: ").append(toIndentedString(taxMode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

