/*
 * Vality Webhooks Events API
 *  ## Webhooks Events API  Данная спецификация определяет протокол доставки оповещений о возникновении новых событий в рамках вашей организации, которые платформа доставляет в виде HTTP-запросов на URL-адреса созданных вами webhook'ов. Обработчики для подобного рода запросов необходимо реализовать на стороне вашего серверного кода согласно данной спецификации.  Webhook — это подписка на определенный тип события либо их группу, касающихся различных объектов в рамках вашей организации. Для управления webhook'ами используются методы Vality API, описанные в спецификации [Vality Webhooks Management API](https://vality.github.io/api#Webhooks). Когда наступает одно из событий в рамках определенного инвойса (например, изменение статуса инвойса или платежа по этому инвойсу), платформа выбирает webhook, подходящий под этот тип события, и отправляет HTTP-запрос, содержащий сообщение в формате JSON на указанный в этом webhook'е URL. Если вы создали несколько webhook'ов, подходящих под этот тип события, то событие доставляется одновременно на все заданные в них URL в неопределённом порядке.  ## Стратегия доставки  Платформа гарантирует порядок доставки событий в рамках определенного инвойса, никакое событие не может быть пропущено и доставлено не в порядке возникновения в платформе. Платформа поддерживает очередь сообщений для каждого инвойса для того, чтобы соблюсти эти гарантии.  Запрос на доставку считается успешным только при получении ответа со статусом `200`. Платформа будет ожидать успешного ответа на отправленный запрос в течение 10 секунд. В случае ответа любым другим статусом или по истечении указанного времени, отведённого на обработку оповещения, платформа будет пытаться повторно доставить оповещения до получения успешного ответа, либо до принятия решения о невозможности доставить информацию. Попытки доставки будут производиться со следующими временными интервалами между запросами:    - 30 секунд,   - 5 минут,   - 15 минут,   - 1 час.   - каждый час в течение суток (24 часа)  Если последняя попытка доставить оповещение оканчивается неудачей, все события, которые накопились в очереди этого инвойса, отбрасываются.  ## Авторизация полученных сообщений  Платформа подтверждает подлинность оповещений, подписывая сообщения приватным ключом, уникальным для каждого webhook'а, парный публичный ключ к которому содержится в данных этого webhook'а. Подпись передается в HTTP-заголовке `Content-Signature`. В заголовке в виде различных атрибутов содержится информация об использованном при формировании подписи алгоритме и значение подписи в формате [URL-safe base-64](https://tools.ietf.org/html/rfc4648).  ``` Content-Signature: alg=RS256; digest=zFuf7bRH4RHwyktaqHQwmX5rn3LfSb4dKo... ```  На данный момент возможно использование единственного алоритма формирования подписи.  ### [RS256](https://tools.ietf.org/html/rfc7518#section-3.3)  Подпись формируется согласно алгоритму [RSASSA-PKCS1-v1_5](https://tools.ietf.org/html/rfc3447#section-8.2), на вход которому подаётся результат вычисления хэша сообщения по алгоритму [SHA-256](https://tools.ietf.org/html/rfc6234).  Набор атрибутов заголовка и список возможных алгоритмов формирования подписи в дальнейшем могут быть расширены. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@vality.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package dev.vality.swag_webhook_events.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.CustomerBindingFailed;
import dev.vality.swag_webhook_events.model.CustomerBindingStarted;
import dev.vality.swag_webhook_events.model.CustomerBindingSucceeded;
import dev.vality.swag_webhook_events.model.CustomerCreated;
import dev.vality.swag_webhook_events.model.CustomerDeleted;
import dev.vality.swag_webhook_events.model.CustomerReady;
import dev.vality.swag_webhook_events.model.InvoiceCancelled;
import dev.vality.swag_webhook_events.model.InvoiceCreated;
import dev.vality.swag_webhook_events.model.InvoiceFulfilled;
import dev.vality.swag_webhook_events.model.InvoicePaid;
import dev.vality.swag_webhook_events.model.PaymentCancelled;
import dev.vality.swag_webhook_events.model.PaymentCaptured;
import dev.vality.swag_webhook_events.model.PaymentFailed;
import dev.vality.swag_webhook_events.model.PaymentProcessed;
import dev.vality.swag_webhook_events.model.PaymentRefunded;
import dev.vality.swag_webhook_events.model.PaymentStarted;
import dev.vality.swag_webhook_events.model.RefundCreated;
import dev.vality.swag_webhook_events.model.RefundFailed;
import dev.vality.swag_webhook_events.model.RefundPending;
import dev.vality.swag_webhook_events.model.RefundSucceeded;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Данные события
 */
@ApiModel(description = "Данные события")
@JsonPropertyOrder({
  Event.JSON_PROPERTY_EVENT_I_D,
  Event.JSON_PROPERTY_OCCURED_AT,
  Event.JSON_PROPERTY_TOPIC,
  Event.JSON_PROPERTY_EVENT_TYPE
})
@JsonTypeName("Event")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-02-21T10:48:08.381944838Z[Etc/UTC]")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "eventType", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = CustomerBindingFailed.class, name = "CustomerBindingFailed"),
  @JsonSubTypes.Type(value = CustomerBindingStarted.class, name = "CustomerBindingStarted"),
  @JsonSubTypes.Type(value = CustomerBindingSucceeded.class, name = "CustomerBindingSucceeded"),
  @JsonSubTypes.Type(value = CustomerCreated.class, name = "CustomerCreated"),
  @JsonSubTypes.Type(value = CustomerDeleted.class, name = "CustomerDeleted"),
  @JsonSubTypes.Type(value = CustomerReady.class, name = "CustomerReady"),
  @JsonSubTypes.Type(value = InvoiceCancelled.class, name = "InvoiceCancelled"),
  @JsonSubTypes.Type(value = InvoiceCreated.class, name = "InvoiceCreated"),
  @JsonSubTypes.Type(value = InvoiceFulfilled.class, name = "InvoiceFulfilled"),
  @JsonSubTypes.Type(value = InvoicePaid.class, name = "InvoicePaid"),
  @JsonSubTypes.Type(value = PaymentCancelled.class, name = "PaymentCancelled"),
  @JsonSubTypes.Type(value = PaymentCaptured.class, name = "PaymentCaptured"),
  @JsonSubTypes.Type(value = PaymentFailed.class, name = "PaymentFailed"),
  @JsonSubTypes.Type(value = PaymentProcessed.class, name = "PaymentProcessed"),
  @JsonSubTypes.Type(value = PaymentRefunded.class, name = "PaymentRefunded"),
  @JsonSubTypes.Type(value = PaymentStarted.class, name = "PaymentStarted"),
  @JsonSubTypes.Type(value = RefundCreated.class, name = "RefundCreated"),
  @JsonSubTypes.Type(value = RefundFailed.class, name = "RefundFailed"),
  @JsonSubTypes.Type(value = RefundPending.class, name = "RefundPending"),
  @JsonSubTypes.Type(value = RefundSucceeded.class, name = "RefundSucceeded"),
})

public class Event {
  public static final String JSON_PROPERTY_EVENT_I_D = "eventID";
  private Integer eventID;

  public static final String JSON_PROPERTY_OCCURED_AT = "occuredAt";
  private OffsetDateTime occuredAt;

  /**
   * Предмет оповещения
   */
  public enum TopicEnum {
    INVOICESTOPIC("InvoicesTopic"),
    
    CUSTOMERSTOPIC("CustomersTopic");

    private String value;

    TopicEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TopicEnum fromValue(String value) {
      for (TopicEnum b : TopicEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TOPIC = "topic";
  private TopicEnum topic;

  /**
   * Тип произошедшего с предметом оповещения события
   */
  public enum EventTypeEnum {
    INVOICECREATED("InvoiceCreated"),
    
    INVOICEPAID("InvoicePaid"),
    
    INVOICECANCELLED("InvoiceCancelled"),
    
    INVOICEFULFILLED("InvoiceFulfilled"),
    
    PAYMENTSTARTED("PaymentStarted"),
    
    PAYMENTPROCESSED("PaymentProcessed"),
    
    PAYMENTCAPTURED("PaymentCaptured"),
    
    PAYMENTCANCELLED("PaymentCancelled"),
    
    PAYMENTREFUNDED("PaymentRefunded"),
    
    PAYMENTFAILED("PaymentFailed"),
    
    REFUNDCREATED("RefundCreated"),
    
    REFUNDPENDING("RefundPending"),
    
    REFUNDSUCCEEDED("RefundSucceeded"),
    
    REFUNDFAILED("RefundFailed"),
    
    CUSTOMERCREATED("CustomerCreated"),
    
    CUSTOMERDELETED("CustomerDeleted"),
    
    CUSTOMERREADY("CustomerReady"),
    
    CUSTOMERBINDINGSTARTED("CustomerBindingStarted"),
    
    CUSTOMERBINDINGSUCCEEDED("CustomerBindingSucceeded"),
    
    CUSTOMERBINDINGFAILED("CustomerBindingFailed");

    private String value;

    EventTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static EventTypeEnum fromValue(String value) {
      for (EventTypeEnum b : EventTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_EVENT_TYPE = "eventType";
  protected EventTypeEnum eventType;

  public Event() { 
  }

  public Event eventID(Integer eventID) {
    
    this.eventID = eventID;
    return this;
  }

   /**
   * Идентификатор события в системе
   * @return eventID
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Идентификатор события в системе")
  @JsonProperty(JSON_PROPERTY_EVENT_I_D)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getEventID() {
    return eventID;
  }


  @JsonProperty(JSON_PROPERTY_EVENT_I_D)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEventID(Integer eventID) {
    this.eventID = eventID;
  }


  public Event occuredAt(OffsetDateTime occuredAt) {
    
    this.occuredAt = occuredAt;
    return this;
  }

   /**
   * Дата и время возникновения события
   * @return occuredAt
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Дата и время возникновения события")
  @JsonProperty(JSON_PROPERTY_OCCURED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getOccuredAt() {
    return occuredAt;
  }


  @JsonProperty(JSON_PROPERTY_OCCURED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOccuredAt(OffsetDateTime occuredAt) {
    this.occuredAt = occuredAt;
  }


  public Event topic(TopicEnum topic) {
    
    this.topic = topic;
    return this;
  }

   /**
   * Предмет оповещения
   * @return topic
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Предмет оповещения")
  @JsonProperty(JSON_PROPERTY_TOPIC)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TopicEnum getTopic() {
    return topic;
  }


  @JsonProperty(JSON_PROPERTY_TOPIC)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTopic(TopicEnum topic) {
    this.topic = topic;
  }


  public Event eventType(EventTypeEnum eventType) {
    
    this.eventType = eventType;
    return this;
  }

   /**
   * Тип произошедшего с предметом оповещения события
   * @return eventType
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Тип произошедшего с предметом оповещения события")
  @JsonProperty(JSON_PROPERTY_EVENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public EventTypeEnum getEventType() {
    return eventType;
  }


  @JsonProperty(JSON_PROPERTY_EVENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEventType(EventTypeEnum eventType) {
    this.eventType = eventType;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Event event = (Event) o;
    return Objects.equals(this.eventID, event.eventID) &&
        Objects.equals(this.occuredAt, event.occuredAt) &&
        Objects.equals(this.topic, event.topic) &&
        Objects.equals(this.eventType, event.eventType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(eventID, occuredAt, topic, eventType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Event {\n");
    sb.append("    eventID: ").append(toIndentedString(eventID)).append("\n");
    sb.append("    occuredAt: ").append(toIndentedString(occuredAt)).append("\n");
    sb.append("    topic: ").append(toIndentedString(topic)).append("\n");
    sb.append("    eventType: ").append(toIndentedString(eventType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

