/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.InvoiceCartLine;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.format.annotation.DateTimeFormat;

@ApiModel(description="\u0414\u0430\u043d\u043d\u044b\u0435 \u0438\u043d\u0432\u043e\u0439\u0441\u0430")
public class Invoice {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="shopID")
    private String shopID;
    @JsonProperty(value="createdAt")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime createdAt;
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonProperty(value="reason")
    private String reason;
    @JsonProperty(value="dueDate")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime dueDate;
    @JsonProperty(value="amount")
    private Long amount;
    @JsonProperty(value="currency")
    private String currency;
    @JsonProperty(value="metadata")
    private Object metadata;
    @JsonProperty(value="product")
    private String product;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="cart")
    @Valid
    private List<InvoiceCartLine> cart = null;

    public Invoice id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0438\u043d\u0432\u043e\u0439\u0441\u0430")
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Invoice shopID(String shopID) {
        this.shopID = shopID;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430")
    @NotNull
    public String getShopID() {
        return this.shopID;
    }

    public void setShopID(String shopID) {
        this.shopID = shopID;
    }

    public Invoice createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f")
    @NotNull
    @Valid
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Invoice status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0421\u0442\u0430\u0442\u0443\u0441 \u0438\u043d\u0432\u043e\u0439\u0441\u0430")
    @NotNull
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Invoice reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="\u041f\u0440\u0438\u0447\u0438\u043d\u0430 \u043e\u0442\u043c\u0435\u043d\u044b \u0438\u043b\u0438 \u043f\u043e\u0433\u0430\u0448\u0435\u043d\u0438\u044f \u0438\u043d\u0432\u043e\u0439\u0441\u0430")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Invoice dueDate(OffsetDateTime dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u0438\u0441\u0442\u0435\u0447\u0435\u043d\u0438\u044f \u0441\u0440\u043e\u043a\u0430 \u0436\u0438\u0437\u043d\u0438")
    @NotNull
    @Valid
    public OffsetDateTime getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(OffsetDateTime dueDate) {
        this.dueDate = dueDate;
    }

    public Invoice amount(Long amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u043c\u044b\u0445 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0438\u043b\u0438 \u0443\u0441\u043b\u0443\u0433, \u0432 \u043c\u0438\u043d\u043e\u0440\u043d\u044b\u0445 \u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0435\u0434\u0438\u043d\u0438\u0446\u0430\u0445, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440 \u0432 \u043a\u043e\u043f\u0435\u0439\u043a\u0430\u0445 \u0432 \u0441\u043b\u0443\u0447\u0430\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0445 \u0440\u0443\u0431\u043b\u0435\u0439 \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0432\u0430\u043b\u044e\u0442\u044b. ")
    @NotNull
    @Min(value=1L)
    public @NotNull @Min(value=1L) Long getAmount() {
        return this.amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public Invoice currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0412\u0430\u043b\u044e\u0442\u0430, \u0441\u0438\u043c\u0432\u043e\u043b\u044c\u043d\u044b\u0439 \u043a\u043e\u0434 \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e [RFC 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). ")
    @NotNull
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Invoice metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0421\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0441 \u0438\u043d\u0432\u043e\u0439\u0441\u043e\u043c \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0435")
    @NotNull
    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public Invoice product(String product) {
        this.product = product;
        return this;
    }

    @ApiModelProperty(required=true, value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u043c\u044b\u0445 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0438\u043b\u0438 \u0443\u0441\u043b\u0443\u0433")
    @NotNull
    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public Invoice description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u043c\u044b\u0445 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0438\u043b\u0438 \u0443\u0441\u043b\u0443\u0433")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Invoice cart(List<InvoiceCartLine> cart) {
        this.cart = cart;
        return this;
    }

    public Invoice addCartItem(InvoiceCartLine cartItem) {
        if (this.cart == null) {
            this.cart = new ArrayList<InvoiceCartLine>();
        }
        this.cart.add(cartItem);
        return this;
    }

    @ApiModelProperty(value="\u041a\u043e\u0440\u0437\u0438\u043d\u0430 \u0441 \u043d\u0430\u0431\u043e\u0440\u043e\u043c \u043f\u043e\u0437\u0438\u0446\u0438\u0439 \u043f\u0440\u043e\u0434\u0430\u0432\u0430\u0435\u043c\u044b\u0445 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0438\u043b\u0438 \u0443\u0441\u043b\u0443\u0433 ")
    @Valid
    @Size(min=1, max=100)
    public @Valid @Size(min=1, max=100) List<InvoiceCartLine> getCart() {
        return this.cart;
    }

    public void setCart(List<InvoiceCartLine> cart) {
        this.cart = cart;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Invoice invoice = (Invoice)o;
        return Objects.equals(this.id, invoice.id) && Objects.equals(this.shopID, invoice.shopID) && Objects.equals(this.createdAt, invoice.createdAt) && Objects.equals((Object)this.status, (Object)invoice.status) && Objects.equals(this.reason, invoice.reason) && Objects.equals(this.dueDate, invoice.dueDate) && Objects.equals(this.amount, invoice.amount) && Objects.equals(this.currency, invoice.currency) && Objects.equals(this.metadata, invoice.metadata) && Objects.equals(this.product, invoice.product) && Objects.equals(this.description, invoice.description) && Objects.equals(this.cart, invoice.cart);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.shopID, this.createdAt, this.status, this.reason, this.dueDate, this.amount, this.currency, this.metadata, this.product, this.description, this.cart});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Invoice {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    shopID: ").append(this.toIndentedString(this.shopID)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    product: ").append(this.toIndentedString(this.product)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    cart: ").append(this.toIndentedString(this.cart)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        UNPAID("unpaid"),
        CANCELLED("cancelled"),
        PAID("paid"),
        REFUNDED("refunded"),
        FULFILLED("fulfilled");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

