package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.ContactInfo;
import dev.vality.swag_webhook_events.model.Payer;
import dev.vality.swag_webhook_events.model.PaymentRecurrentParent;
import dev.vality.swag_webhook_events.model.RecurrentPayerAllOf;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Многоразовое платежное средство на основе другого платежа
 */
@ApiModel(description = "Многоразовое платежное средство на основе другого платежа")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-02-11T15:31:13.614248567Z[Etc/UTC]")
public class RecurrentPayer extends Payer  {
  @JsonProperty("contactInfo")
  private ContactInfo contactInfo;

  @JsonProperty("recurrentParentPayment")
  private PaymentRecurrentParent recurrentParentPayment;

  public RecurrentPayer contactInfo(ContactInfo contactInfo) {
    this.contactInfo = contactInfo;
    return this;
  }

  /**
   * Get contactInfo
   * @return contactInfo
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public ContactInfo getContactInfo() {
    return contactInfo;
  }

  public void setContactInfo(ContactInfo contactInfo) {
    this.contactInfo = contactInfo;
  }

  public RecurrentPayer recurrentParentPayment(PaymentRecurrentParent recurrentParentPayment) {
    this.recurrentParentPayment = recurrentParentPayment;
    return this;
  }

  /**
   * Get recurrentParentPayment
   * @return recurrentParentPayment
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public PaymentRecurrentParent getRecurrentParentPayment() {
    return recurrentParentPayment;
  }

  public void setRecurrentParentPayment(PaymentRecurrentParent recurrentParentPayment) {
    this.recurrentParentPayment = recurrentParentPayment;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RecurrentPayer recurrentPayer = (RecurrentPayer) o;
    return Objects.equals(this.contactInfo, recurrentPayer.contactInfo) &&
        Objects.equals(this.recurrentParentPayment, recurrentPayer.recurrentParentPayment) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(contactInfo, recurrentParentPayment, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RecurrentPayer {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    contactInfo: ").append(toIndentedString(contactInfo)).append("\n");
    sb.append("    recurrentParentPayment: ").append(toIndentedString(recurrentParentPayment)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

