package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Детали платежного средства
 */
@ApiModel(description = "Детали платежного средства")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-02-11T15:31:13.614248567Z[Etc/UTC]")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "detailsType", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = PaymentToolDetailsBankCard.class, name = "PaymentToolDetailsBankCard"),
  @JsonSubTypes.Type(value = PaymentToolDetailsCryptoWallet.class, name = "PaymentToolDetailsCryptoWallet"),
  @JsonSubTypes.Type(value = PaymentToolDetailsDigitalWallet.class, name = "PaymentToolDetailsDigitalWallet"),
  @JsonSubTypes.Type(value = PaymentToolDetailsMobileCommerce.class, name = "PaymentToolDetailsMobileCommerce"),
  @JsonSubTypes.Type(value = PaymentToolDetailsPaymentTerminal.class, name = "PaymentToolDetailsPaymentTerminal"),
})

public class PaymentToolDetails   {
  /**
   * Тип информации о платежном средстве
   */
  public enum DetailsTypeEnum {
    PAYMENTTOOLDETAILSBANKCARD("PaymentToolDetailsBankCard"),
    
    PAYMENTTOOLDETAILSPAYMENTTERMINAL("PaymentToolDetailsPaymentTerminal"),
    
    PAYMENTTOOLDETAILSDIGITALWALLET("PaymentToolDetailsDigitalWallet"),
    
    PAYMENTTOOLDETAILSCRYPTOWALLET("PaymentToolDetailsCryptoWallet"),
    
    PAYMENTTOOLDETAILSMOBILECOMMERCE("PaymentToolDetailsMobileCommerce");

    private String value;

    DetailsTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DetailsTypeEnum fromValue(String value) {
      for (DetailsTypeEnum b : DetailsTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("detailsType")
  private DetailsTypeEnum detailsType;

  public PaymentToolDetails detailsType(DetailsTypeEnum detailsType) {
    this.detailsType = detailsType;
    return this;
  }

  /**
   * Тип информации о платежном средстве
   * @return detailsType
  */
  @ApiModelProperty(required = true, value = "Тип информации о платежном средстве")
  @NotNull


  public DetailsTypeEnum getDetailsType() {
    return detailsType;
  }

  public void setDetailsType(DetailsTypeEnum detailsType) {
    this.detailsType = detailsType;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentToolDetails paymentToolDetails = (PaymentToolDetails) o;
    return Objects.equals(this.detailsType, paymentToolDetails.detailsType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(detailsType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentToolDetails {\n");
    
    sb.append("    detailsType: ").append(toIndentedString(detailsType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

