package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.ClientInfo;
import dev.vality.swag_webhook_events.model.ContactInfo;
import dev.vality.swag_webhook_events.model.Payer;
import dev.vality.swag_webhook_events.model.PaymentResource;
import dev.vality.swag_webhook_events.model.PaymentResourcePayerAllOf;
import dev.vality.swag_webhook_events.model.PaymentToolDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Платежное средство
 */
@ApiModel(description = "Платежное средство")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-02-11T15:31:13.614248567Z[Etc/UTC]")
public class PaymentResourcePayer extends Payer  {
  @JsonProperty("paymentToolToken")
  private String paymentToolToken;

  @JsonProperty("paymentSession")
  private String paymentSession;

  @JsonProperty("paymentToolDetails")
  private PaymentToolDetails paymentToolDetails;

  @JsonProperty("clientInfo")
  private ClientInfo clientInfo;

  @JsonProperty("contactInfo")
  private ContactInfo contactInfo;

  public PaymentResourcePayer paymentToolToken(String paymentToolToken) {
    this.paymentToolToken = paymentToolToken;
    return this;
  }

  /**
   * Токен платежного средства, предоставленного плательщиком
   * @return paymentToolToken
  */
  @ApiModelProperty(required = true, value = "Токен платежного средства, предоставленного плательщиком")
  @NotNull

@Size(max = 1000) 
  public String getPaymentToolToken() {
    return paymentToolToken;
  }

  public void setPaymentToolToken(String paymentToolToken) {
    this.paymentToolToken = paymentToolToken;
  }

  public PaymentResourcePayer paymentSession(String paymentSession) {
    this.paymentSession = paymentSession;
    return this;
  }

  /**
   * Идентификатор платежной сессии
   * @return paymentSession
  */
  @ApiModelProperty(required = true, value = "Идентификатор платежной сессии")
  @NotNull

@Size(max = 1000) 
  public String getPaymentSession() {
    return paymentSession;
  }

  public void setPaymentSession(String paymentSession) {
    this.paymentSession = paymentSession;
  }

  public PaymentResourcePayer paymentToolDetails(PaymentToolDetails paymentToolDetails) {
    this.paymentToolDetails = paymentToolDetails;
    return this;
  }

  /**
   * Get paymentToolDetails
   * @return paymentToolDetails
  */
  @ApiModelProperty(value = "")

  @Valid

  public PaymentToolDetails getPaymentToolDetails() {
    return paymentToolDetails;
  }

  public void setPaymentToolDetails(PaymentToolDetails paymentToolDetails) {
    this.paymentToolDetails = paymentToolDetails;
  }

  public PaymentResourcePayer clientInfo(ClientInfo clientInfo) {
    this.clientInfo = clientInfo;
    return this;
  }

  /**
   * Get clientInfo
   * @return clientInfo
  */
  @ApiModelProperty(value = "")

  @Valid

  public ClientInfo getClientInfo() {
    return clientInfo;
  }

  public void setClientInfo(ClientInfo clientInfo) {
    this.clientInfo = clientInfo;
  }

  public PaymentResourcePayer contactInfo(ContactInfo contactInfo) {
    this.contactInfo = contactInfo;
    return this;
  }

  /**
   * Get contactInfo
   * @return contactInfo
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public ContactInfo getContactInfo() {
    return contactInfo;
  }

  public void setContactInfo(ContactInfo contactInfo) {
    this.contactInfo = contactInfo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentResourcePayer paymentResourcePayer = (PaymentResourcePayer) o;
    return Objects.equals(this.paymentToolToken, paymentResourcePayer.paymentToolToken) &&
        Objects.equals(this.paymentSession, paymentResourcePayer.paymentSession) &&
        Objects.equals(this.paymentToolDetails, paymentResourcePayer.paymentToolDetails) &&
        Objects.equals(this.clientInfo, paymentResourcePayer.clientInfo) &&
        Objects.equals(this.contactInfo, paymentResourcePayer.contactInfo) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paymentToolToken, paymentSession, paymentToolDetails, clientInfo, contactInfo, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentResourcePayer {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    paymentToolToken: ").append(toIndentedString(paymentToolToken)).append("\n");
    sb.append("    paymentSession: ").append(toIndentedString(paymentSession)).append("\n");
    sb.append("    paymentToolDetails: ").append(toIndentedString(paymentToolDetails)).append("\n");
    sb.append("    clientInfo: ").append(toIndentedString(clientInfo)).append("\n");
    sb.append("    contactInfo: ").append(toIndentedString(contactInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

