package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.Event;
import dev.vality.swag_webhook_events.model.Invoice;
import dev.vality.swag_webhook_events.model.Payment;
import dev.vality.swag_webhook_events.model.PaymentStartedAllOf;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Событие о неуспешном завершении платежа с указанием причины, например в случае отсутствия достаточного количества денежных средств у плательщика 
 */
@ApiModel(description = "Событие о неуспешном завершении платежа с указанием причины, например в случае отсутствия достаточного количества денежных средств у плательщика ")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-02-11T15:31:13.614248567Z[Etc/UTC]")
public class PaymentFailed extends Event  {
  @JsonProperty("invoice")
  private Invoice invoice;

  @JsonProperty("payment")
  private Payment payment;

  public PaymentFailed invoice(Invoice invoice) {
    this.invoice = invoice;
    return this;
  }

  /**
   * Get invoice
   * @return invoice
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public Invoice getInvoice() {
    return invoice;
  }

  public void setInvoice(Invoice invoice) {
    this.invoice = invoice;
  }

  public PaymentFailed payment(Payment payment) {
    this.payment = payment;
    return this;
  }

  /**
   * Get payment
   * @return payment
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public Payment getPayment() {
    return payment;
  }

  public void setPayment(Payment payment) {
    this.payment = payment;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentFailed paymentFailed = (PaymentFailed) o;
    return Objects.equals(this.invoice, paymentFailed.invoice) &&
        Objects.equals(this.payment, paymentFailed.payment) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoice, payment, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentFailed {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    invoice: ").append(toIndentedString(invoice)).append("\n");
    sb.append("    payment: ").append(toIndentedString(payment)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

