package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.Payer;
import dev.vality.swag_webhook_events.model.PaymentContactInfo;
import dev.vality.swag_webhook_events.model.PaymentError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Данные платежа в рамках инвойса
 */
@ApiModel(description = "Данные платежа в рамках инвойса")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-02-11T15:31:13.614248567Z[Etc/UTC]")
public class Payment   {
  @JsonProperty("id")
  private String id;

  @JsonProperty("createdAt")
  @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdAt;

  /**
   * Статус платежа
   */
  public enum StatusEnum {
    PENDING("pending"),
    
    PROCESSED("processed"),
    
    CAPTURED("captured"),
    
    CANCELLED("cancelled"),
    
    REFUNDED("refunded"),
    
    FAILED("failed");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("status")
  private StatusEnum status;

  @JsonProperty("error")
  private PaymentError error;

  @JsonProperty("amount")
  private Long amount;

  @JsonProperty("currency")
  private String currency;

  @JsonProperty("metadata")
  private Object metadata;

  @JsonProperty("paymentToolToken")
  private String paymentToolToken;

  @JsonProperty("paymentSession")
  private String paymentSession;

  @JsonProperty("contactInfo")
  private PaymentContactInfo contactInfo;

  @JsonProperty("ip")
  private String ip;

  @JsonProperty("fingerprint")
  private String fingerprint;

  @JsonProperty("payer")
  private Payer payer;

  @JsonProperty("fee")
  private Long fee;

  @JsonProperty("rrn")
  private String rrn;

  public Payment id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Идентификатор платежа
   * @return id
  */
  @ApiModelProperty(required = true, value = "Идентификатор платежа")
  @NotNull


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Payment createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Дата и время создания
   * @return createdAt
  */
  @ApiModelProperty(required = true, value = "Дата и время создания")
  @NotNull

  @Valid

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public Payment status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * Статус платежа
   * @return status
  */
  @ApiModelProperty(required = true, value = "Статус платежа")
  @NotNull


  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public Payment error(PaymentError error) {
    this.error = error;
    return this;
  }

  /**
   * Get error
   * @return error
  */
  @ApiModelProperty(value = "")

  @Valid

  public PaymentError getError() {
    return error;
  }

  public void setError(PaymentError error) {
    this.error = error;
  }

  public Payment amount(Long amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Стоимость предлагаемых товаров или услуг, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. 
   * minimum: 1
   * @return amount
  */
  @ApiModelProperty(required = true, value = "Стоимость предлагаемых товаров или услуг, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. ")
  @NotNull

@Min(1L) 
  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public Payment currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Валюта, символьный код согласно [RFC 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). 
   * @return currency
  */
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [RFC 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). ")
  @NotNull


  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public Payment metadata(Object metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Связанные с платежом метаданные
   * @return metadata
  */
  @ApiModelProperty(value = "Связанные с платежом метаданные")


  public Object getMetadata() {
    return metadata;
  }

  public void setMetadata(Object metadata) {
    this.metadata = metadata;
  }

  public Payment paymentToolToken(String paymentToolToken) {
    this.paymentToolToken = paymentToolToken;
    return this;
  }

  /**
   * **Deprecated.** _Используйте свойство `payer`._ Токен платежного средства, предоставленного плательщиком 
   * @return paymentToolToken
  */
  @ApiModelProperty(value = "**Deprecated.** _Используйте свойство `payer`._ Токен платежного средства, предоставленного плательщиком ")


  public String getPaymentToolToken() {
    return paymentToolToken;
  }

  public void setPaymentToolToken(String paymentToolToken) {
    this.paymentToolToken = paymentToolToken;
  }

  public Payment paymentSession(String paymentSession) {
    this.paymentSession = paymentSession;
    return this;
  }

  /**
   * **Deprecated.** _Используйте свойство `payer`._ Идентификатор платежной сессии 
   * @return paymentSession
  */
  @ApiModelProperty(required = true, value = "**Deprecated.** _Используйте свойство `payer`._ Идентификатор платежной сессии ")
  @NotNull


  public String getPaymentSession() {
    return paymentSession;
  }

  public void setPaymentSession(String paymentSession) {
    this.paymentSession = paymentSession;
  }

  public Payment contactInfo(PaymentContactInfo contactInfo) {
    this.contactInfo = contactInfo;
    return this;
  }

  /**
   * Get contactInfo
   * @return contactInfo
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public PaymentContactInfo getContactInfo() {
    return contactInfo;
  }

  public void setContactInfo(PaymentContactInfo contactInfo) {
    this.contactInfo = contactInfo;
  }

  public Payment ip(String ip) {
    this.ip = ip;
    return this;
  }

  /**
   * **Deprecated.** _Используйте свойство `payer`._ IP-адрес плательщика 
   * @return ip
  */
  @ApiModelProperty(value = "**Deprecated.** _Используйте свойство `payer`._ IP-адрес плательщика ")


  public String getIp() {
    return ip;
  }

  public void setIp(String ip) {
    this.ip = ip;
  }

  public Payment fingerprint(String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }

  /**
   * **Deprecated.** _Используйте свойство `payer`._ Уникальный отпечаток user agent'а плательщика 
   * @return fingerprint
  */
  @ApiModelProperty(value = "**Deprecated.** _Используйте свойство `payer`._ Уникальный отпечаток user agent'а плательщика ")


  public String getFingerprint() {
    return fingerprint;
  }

  public void setFingerprint(String fingerprint) {
    this.fingerprint = fingerprint;
  }

  public Payment payer(Payer payer) {
    this.payer = payer;
    return this;
  }

  /**
   * Get payer
   * @return payer
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public Payer getPayer() {
    return payer;
  }

  public void setPayer(Payer payer) {
    this.payer = payer;
  }

  public Payment fee(Long fee) {
    this.fee = fee;
    return this;
  }

  /**
   * Комиссия системы, в минорных денежных единицах. 
   * @return fee
  */
  @ApiModelProperty(value = "Комиссия системы, в минорных денежных единицах. ")


  public Long getFee() {
    return fee;
  }

  public void setFee(Long fee) {
    this.fee = fee;
  }

  public Payment rrn(String rrn) {
    this.rrn = rrn;
    return this;
  }

  /**
   * Уникальный номер транзакции в системе авторизации и расчетов обслуживающего банка 
   * @return rrn
  */
  @ApiModelProperty(value = "Уникальный номер транзакции в системе авторизации и расчетов обслуживающего банка ")


  public String getRrn() {
    return rrn;
  }

  public void setRrn(String rrn) {
    this.rrn = rrn;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Payment payment = (Payment) o;
    return Objects.equals(this.id, payment.id) &&
        Objects.equals(this.createdAt, payment.createdAt) &&
        Objects.equals(this.status, payment.status) &&
        Objects.equals(this.error, payment.error) &&
        Objects.equals(this.amount, payment.amount) &&
        Objects.equals(this.currency, payment.currency) &&
        Objects.equals(this.metadata, payment.metadata) &&
        Objects.equals(this.paymentToolToken, payment.paymentToolToken) &&
        Objects.equals(this.paymentSession, payment.paymentSession) &&
        Objects.equals(this.contactInfo, payment.contactInfo) &&
        Objects.equals(this.ip, payment.ip) &&
        Objects.equals(this.fingerprint, payment.fingerprint) &&
        Objects.equals(this.payer, payment.payer) &&
        Objects.equals(this.fee, payment.fee) &&
        Objects.equals(this.rrn, payment.rrn);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdAt, status, error, amount, currency, metadata, paymentToolToken, paymentSession, contactInfo, ip, fingerprint, payer, fee, rrn);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Payment {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    paymentToolToken: ").append(toIndentedString(paymentToolToken)).append("\n");
    sb.append("    paymentSession: ").append(toIndentedString(paymentSession)).append("\n");
    sb.append("    contactInfo: ").append(toIndentedString(contactInfo)).append("\n");
    sb.append("    ip: ").append(toIndentedString(ip)).append("\n");
    sb.append("    fingerprint: ").append(toIndentedString(fingerprint)).append("\n");
    sb.append("    payer: ").append(toIndentedString(payer)).append("\n");
    sb.append("    fee: ").append(toIndentedString(fee)).append("\n");
    sb.append("    rrn: ").append(toIndentedString(rrn)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

