package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Payer
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-02-11T15:31:13.614248567Z[Etc/UTC]")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "payerType", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = CustomerPayer.class, name = "CustomerPayer"),
  @JsonSubTypes.Type(value = PaymentResourcePayer.class, name = "PaymentResourcePayer"),
  @JsonSubTypes.Type(value = RecurrentPayer.class, name = "RecurrentPayer"),
})

public class Payer   {
  /**
   * Тип платежного средства
   */
  public enum PayerTypeEnum {
    CUSTOMERPAYER("CustomerPayer"),
    
    PAYMENTRESOURCEPAYER("PaymentResourcePayer"),
    
    RECURRENTPAYER("RecurrentPayer");

    private String value;

    PayerTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PayerTypeEnum fromValue(String value) {
      for (PayerTypeEnum b : PayerTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("payerType")
  private PayerTypeEnum payerType;

  public Payer payerType(PayerTypeEnum payerType) {
    this.payerType = payerType;
    return this;
  }

  /**
   * Тип платежного средства
   * @return payerType
  */
  @ApiModelProperty(required = true, value = "Тип платежного средства")
  @NotNull


  public PayerTypeEnum getPayerType() {
    return payerType;
  }

  public void setPayerType(PayerTypeEnum payerType) {
    this.payerType = payerType;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Payer payer = (Payer) o;
    return Objects.equals(this.payerType, payer.payerType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(payerType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Payer {\n");
    
    sb.append("    payerType: ").append(toIndentedString(payerType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

