package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Данные события
 */
@ApiModel(description = "Данные события")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-02-11T15:31:13.614248567Z[Etc/UTC]")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "eventType", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = CustomerBindingFailed.class, name = "CustomerBindingFailed"),
  @JsonSubTypes.Type(value = CustomerBindingStarted.class, name = "CustomerBindingStarted"),
  @JsonSubTypes.Type(value = CustomerBindingSucceeded.class, name = "CustomerBindingSucceeded"),
  @JsonSubTypes.Type(value = CustomerCreated.class, name = "CustomerCreated"),
  @JsonSubTypes.Type(value = CustomerDeleted.class, name = "CustomerDeleted"),
  @JsonSubTypes.Type(value = CustomerReady.class, name = "CustomerReady"),
  @JsonSubTypes.Type(value = InvoiceCancelled.class, name = "InvoiceCancelled"),
  @JsonSubTypes.Type(value = InvoiceCreated.class, name = "InvoiceCreated"),
  @JsonSubTypes.Type(value = InvoiceFulfilled.class, name = "InvoiceFulfilled"),
  @JsonSubTypes.Type(value = InvoicePaid.class, name = "InvoicePaid"),
  @JsonSubTypes.Type(value = PaymentCancelled.class, name = "PaymentCancelled"),
  @JsonSubTypes.Type(value = PaymentCaptured.class, name = "PaymentCaptured"),
  @JsonSubTypes.Type(value = PaymentFailed.class, name = "PaymentFailed"),
  @JsonSubTypes.Type(value = PaymentProcessed.class, name = "PaymentProcessed"),
  @JsonSubTypes.Type(value = PaymentRefunded.class, name = "PaymentRefunded"),
  @JsonSubTypes.Type(value = PaymentStarted.class, name = "PaymentStarted"),
  @JsonSubTypes.Type(value = RefundCreated.class, name = "RefundCreated"),
  @JsonSubTypes.Type(value = RefundFailed.class, name = "RefundFailed"),
  @JsonSubTypes.Type(value = RefundPending.class, name = "RefundPending"),
  @JsonSubTypes.Type(value = RefundSucceeded.class, name = "RefundSucceeded"),
})

public class Event   {
  @JsonProperty("eventID")
  private Integer eventID;

  @JsonProperty("occuredAt")
  @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime occuredAt;

  /**
   * Предмет оповещения
   */
  public enum TopicEnum {
    INVOICESTOPIC("InvoicesTopic"),
    
    CUSTOMERSTOPIC("CustomersTopic");

    private String value;

    TopicEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TopicEnum fromValue(String value) {
      for (TopicEnum b : TopicEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("topic")
  private TopicEnum topic;

  /**
   * Тип произошедшего с предметом оповещения события
   */
  public enum EventTypeEnum {
    INVOICECREATED("InvoiceCreated"),
    
    INVOICEPAID("InvoicePaid"),
    
    INVOICECANCELLED("InvoiceCancelled"),
    
    INVOICEFULFILLED("InvoiceFulfilled"),
    
    PAYMENTSTARTED("PaymentStarted"),
    
    PAYMENTPROCESSED("PaymentProcessed"),
    
    PAYMENTCAPTURED("PaymentCaptured"),
    
    PAYMENTCANCELLED("PaymentCancelled"),
    
    PAYMENTREFUNDED("PaymentRefunded"),
    
    PAYMENTFAILED("PaymentFailed"),
    
    REFUNDCREATED("RefundCreated"),
    
    REFUNDPENDING("RefundPending"),
    
    REFUNDSUCCEEDED("RefundSucceeded"),
    
    REFUNDFAILED("RefundFailed"),
    
    CUSTOMERCREATED("CustomerCreated"),
    
    CUSTOMERDELETED("CustomerDeleted"),
    
    CUSTOMERREADY("CustomerReady"),
    
    CUSTOMERBINDINGSTARTED("CustomerBindingStarted"),
    
    CUSTOMERBINDINGSUCCEEDED("CustomerBindingSucceeded"),
    
    CUSTOMERBINDINGFAILED("CustomerBindingFailed");

    private String value;

    EventTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static EventTypeEnum fromValue(String value) {
      for (EventTypeEnum b : EventTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("eventType")
  private EventTypeEnum eventType;

  public Event eventID(Integer eventID) {
    this.eventID = eventID;
    return this;
  }

  /**
   * Идентификатор события в системе
   * @return eventID
  */
  @ApiModelProperty(required = true, value = "Идентификатор события в системе")
  @NotNull


  public Integer getEventID() {
    return eventID;
  }

  public void setEventID(Integer eventID) {
    this.eventID = eventID;
  }

  public Event occuredAt(OffsetDateTime occuredAt) {
    this.occuredAt = occuredAt;
    return this;
  }

  /**
   * Дата и время возникновения события
   * @return occuredAt
  */
  @ApiModelProperty(required = true, value = "Дата и время возникновения события")
  @NotNull

  @Valid

  public OffsetDateTime getOccuredAt() {
    return occuredAt;
  }

  public void setOccuredAt(OffsetDateTime occuredAt) {
    this.occuredAt = occuredAt;
  }

  public Event topic(TopicEnum topic) {
    this.topic = topic;
    return this;
  }

  /**
   * Предмет оповещения
   * @return topic
  */
  @ApiModelProperty(required = true, value = "Предмет оповещения")
  @NotNull


  public TopicEnum getTopic() {
    return topic;
  }

  public void setTopic(TopicEnum topic) {
    this.topic = topic;
  }

  public Event eventType(EventTypeEnum eventType) {
    this.eventType = eventType;
    return this;
  }

  /**
   * Тип произошедшего с предметом оповещения события
   * @return eventType
  */
  @ApiModelProperty(required = true, value = "Тип произошедшего с предметом оповещения события")
  @NotNull


  public EventTypeEnum getEventType() {
    return eventType;
  }

  public void setEventType(EventTypeEnum eventType) {
    this.eventType = eventType;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Event event = (Event) o;
    return Objects.equals(this.eventID, event.eventID) &&
        Objects.equals(this.occuredAt, event.occuredAt) &&
        Objects.equals(this.topic, event.topic) &&
        Objects.equals(this.eventType, event.eventType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(eventID, occuredAt, topic, eventType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Event {\n");
    
    sb.append("    eventID: ").append(toIndentedString(eventID)).append("\n");
    sb.append("    occuredAt: ").append(toIndentedString(occuredAt)).append("\n");
    sb.append("    topic: ").append(toIndentedString(topic)).append("\n");
    sb.append("    eventType: ").append(toIndentedString(eventType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

