package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.CustomerBindingAllOf;
import dev.vality.swag_webhook_events.model.CustomerBindingError;
import dev.vality.swag_webhook_events.model.CustomerBindingStatus;
import dev.vality.swag_webhook_events.model.PaymentResource;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Привязка плательщика к платежному средству
 */
@ApiModel(description = "Привязка плательщика к платежному средству")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-02-11T15:31:13.614248567Z[Etc/UTC]")
public class CustomerBinding   {
  /**
   * Статус привязки
   */
  public enum StatusEnum {
    PENDING("pending"),
    
    SUCCEEDED("succeeded"),
    
    FAILED("failed");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("status")
  private StatusEnum status;

  @JsonProperty("error")
  private CustomerBindingError error;

  @JsonProperty("id")
  private String id;

  @JsonProperty("paymentResource")
  private PaymentResource paymentResource;

  public CustomerBinding status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * Статус привязки
   * @return status
  */
  @ApiModelProperty(required = true, value = "Статус привязки")
  @NotNull


  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public CustomerBinding error(CustomerBindingError error) {
    this.error = error;
    return this;
  }

  /**
   * Get error
   * @return error
  */
  @ApiModelProperty(value = "")

  @Valid

  public CustomerBindingError getError() {
    return error;
  }

  public void setError(CustomerBindingError error) {
    this.error = error;
  }

  public CustomerBinding id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Идентификатор привязки
   * @return id
  */
  @ApiModelProperty(required = true, value = "Идентификатор привязки")
  @NotNull


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public CustomerBinding paymentResource(PaymentResource paymentResource) {
    this.paymentResource = paymentResource;
    return this;
  }

  /**
   * Get paymentResource
   * @return paymentResource
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public PaymentResource getPaymentResource() {
    return paymentResource;
  }

  public void setPaymentResource(PaymentResource paymentResource) {
    this.paymentResource = paymentResource;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CustomerBinding customerBinding = (CustomerBinding) o;
    return Objects.equals(this.status, customerBinding.status) &&
        Objects.equals(this.error, customerBinding.error) &&
        Objects.equals(this.id, customerBinding.id) &&
        Objects.equals(this.paymentResource, customerBinding.paymentResource);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status, error, id, paymentResource);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CustomerBinding {\n");
    
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    paymentResource: ").append(toIndentedString(paymentResource)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

