/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"bin", "lastDigits", "cardNumberMask", "paymentSystem", "tokenProvider", "issuerCountry", "bankName"})
@JsonTypeName(value="BankCardDetails")
public class BankCardDetails {
    public static final String JSON_PROPERTY_BIN = "bin";
    private String bin;
    public static final String JSON_PROPERTY_LAST_DIGITS = "lastDigits";
    private String lastDigits;
    public static final String JSON_PROPERTY_CARD_NUMBER_MASK = "cardNumberMask";
    private String cardNumberMask;
    public static final String JSON_PROPERTY_PAYMENT_SYSTEM = "paymentSystem";
    private String paymentSystem;
    public static final String JSON_PROPERTY_TOKEN_PROVIDER = "tokenProvider";
    private TokenProviderEnum tokenProvider;
    public static final String JSON_PROPERTY_ISSUER_COUNTRY = "issuerCountry";
    private String issuerCountry;
    public static final String JSON_PROPERTY_BANK_NAME = "bankName";
    private String bankName;

    public BankCardDetails bin(String bin) {
        this.bin = bin;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="\u0411\u0418\u041d \u0431\u0430\u043d\u043a\u0430-\u044d\u043c\u0438\u0442\u0435\u043d\u0442\u0430 \u043a\u0430\u0440\u0442\u044b")
    @JsonProperty(value="bin")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBin() {
        return this.bin;
    }

    @JsonProperty(value="bin")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBin(String bin) {
        this.bin = bin;
    }

    public BankCardDetails lastDigits(String lastDigits) {
        this.lastDigits = lastDigits;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u0446\u0438\u0444\u0440\u044b \u043d\u043e\u043c\u0435\u0440\u0430 \u043a\u0430\u0440\u0442\u044b")
    @JsonProperty(value="lastDigits")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLastDigits() {
        return this.lastDigits;
    }

    @JsonProperty(value="lastDigits")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLastDigits(String lastDigits) {
        this.lastDigits = lastDigits;
    }

    public BankCardDetails cardNumberMask(String cardNumberMask) {
        this.cardNumberMask = cardNumberMask;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="\u041c\u0430\u0441\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043a\u0430\u0440\u0442\u044b")
    @JsonProperty(value="cardNumberMask")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCardNumberMask() {
        return this.cardNumberMask;
    }

    @JsonProperty(value="cardNumberMask")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCardNumberMask(String cardNumberMask) {
        this.cardNumberMask = cardNumberMask;
    }

    public BankCardDetails paymentSystem(String paymentSystem) {
        this.paymentSystem = paymentSystem;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430")
    @JsonProperty(value="paymentSystem")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPaymentSystem() {
        return this.paymentSystem;
    }

    @JsonProperty(value="paymentSystem")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPaymentSystem(String paymentSystem) {
        this.paymentSystem = paymentSystem;
    }

    public BankCardDetails tokenProvider(TokenProviderEnum tokenProvider) {
        this.tokenProvider = tokenProvider;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="\u041f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0445 \u0442\u043e\u043a\u0435\u043d\u043e\u0432")
    @JsonProperty(value="tokenProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TokenProviderEnum getTokenProvider() {
        return this.tokenProvider;
    }

    @JsonProperty(value="tokenProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokenProvider(TokenProviderEnum tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public BankCardDetails issuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"RUS\",\"POL\",\"USA\"]", value="\u0421\u0442\u0440\u0430\u043d\u0430 \u044d\u043c\u0438\u0442\u0435\u043d\u0442 (alpha-3 \u043a\u043e\u0434 \u043f\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u0443 ISO_3166-1)")
    @JsonProperty(value="issuerCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuerCountry() {
        return this.issuerCountry;
    }

    @JsonProperty(value="issuerCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
    }

    public BankCardDetails bankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"SBERBANK OF RUSSIA\",\"JOINT STOCK COMPANY ALFA-BANK\",\"VTB BANK OJSC\"]", value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0431\u0430\u043d\u043a\u0430")
    @JsonProperty(value="bankName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankName() {
        return this.bankName;
    }

    @JsonProperty(value="bankName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankCardDetails bankCardDetails = (BankCardDetails)o;
        return Objects.equals(this.bin, bankCardDetails.bin) && Objects.equals(this.lastDigits, bankCardDetails.lastDigits) && Objects.equals(this.cardNumberMask, bankCardDetails.cardNumberMask) && Objects.equals(this.paymentSystem, bankCardDetails.paymentSystem) && Objects.equals((Object)this.tokenProvider, (Object)bankCardDetails.tokenProvider) && Objects.equals(this.issuerCountry, bankCardDetails.issuerCountry) && Objects.equals(this.bankName, bankCardDetails.bankName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bin, this.lastDigits, this.cardNumberMask, this.paymentSystem, this.tokenProvider, this.issuerCountry, this.bankName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankCardDetails {\n");
        sb.append("    bin: ").append(this.toIndentedString(this.bin)).append("\n");
        sb.append("    lastDigits: ").append(this.toIndentedString(this.lastDigits)).append("\n");
        sb.append("    cardNumberMask: ").append(this.toIndentedString(this.cardNumberMask)).append("\n");
        sb.append("    paymentSystem: ").append(this.toIndentedString(this.paymentSystem)).append("\n");
        sb.append("    tokenProvider: ").append(this.toIndentedString((Object)this.tokenProvider)).append("\n");
        sb.append("    issuerCountry: ").append(this.toIndentedString(this.issuerCountry)).append("\n");
        sb.append("    bankName: ").append(this.toIndentedString(this.bankName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TokenProviderEnum {
        APPLEPAY("applepay"),
        GOOGLEPAY("googlepay"),
        SAMSUNGPAY("samsungpay"),
        YANDEXPAY("yandexpay");

        private String value;

        private TokenProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TokenProviderEnum fromValue(String value) {
            for (TokenProviderEnum b : TokenProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

