/*
 * Vality Webhooks Events API
 *  ## Webhooks Events API  Данная спецификация определяет протокол доставки оповещений о возникновении новых событий в рамках вашей организации, которые платформа доставляет в виде HTTP-запросов на URL-адреса созданных вами webhook'ов. Обработчики для подобного рода запросов необходимо реализовать на стороне вашего серверного кода согласно данной спецификации.  Webhook — это подписка на определенный тип события либо их группу, касающихся различных объектов в рамках вашей организации. Для управления webhook'ами используются методы Vality API, описанные в спецификации [Vality Webhooks Management API](https://vality.github.io/api#Webhooks). Когда наступает одно из событий в рамках определенного инвойса (например, изменение статуса инвойса или платежа по этому инвойсу), платформа выбирает webhook, подходящий под этот тип события, и отправляет HTTP-запрос, содержащий сообщение в формате JSON на указанный в этом webhook'е URL. Если вы создали несколько webhook'ов, подходящих под этот тип события, то событие доставляется одновременно на все заданные в них URL в неопределённом порядке.  ## Стратегия доставки  Платформа гарантирует порядок доставки событий в рамках определенного инвойса, никакое событие не может быть пропущено и доставлено не в порядке возникновения в платформе. Платформа поддерживает очередь сообщений для каждого инвойса для того, чтобы соблюсти эти гарантии.  Запрос на доставку считается успешным только при получении ответа со статусом `200`. Платформа будет ожидать успешного ответа на отправленный запрос в течение 10 секунд. В случае ответа любым другим статусом или по истечении указанного времени, отведённого на обработку оповещения, платформа будет пытаться повторно доставить оповещения до получения успешного ответа, либо до принятия решения о невозможности доставить информацию. Попытки доставки будут производиться со следующими временными интервалами между запросами:    - 30 секунд,   - 5 минут,   - 15 минут,   - 1 час.   - каждый час в течение суток (24 часа)  Если последняя попытка доставить оповещение оканчивается неудачей, все события, которые накопились в очереди этого инвойса, отбрасываются.  ## Авторизация полученных сообщений  Платформа подтверждает подлинность оповещений, подписывая сообщения приватным ключом, уникальным для каждого webhook'а, парный публичный ключ к которому содержится в данных этого webhook'а. Подпись передается в HTTP-заголовке `Content-Signature`. В заголовке в виде различных атрибутов содержится информация об использованном при формировании подписи алгоритме и значение подписи в формате [URL-safe base-64](https://tools.ietf.org/html/rfc4648).  ``` Content-Signature: alg=RS256; digest=zFuf7bRH4RHwyktaqHQwmX5rn3LfSb4dKo... ```  На данный момент возможно использование единственного алоритма формирования подписи.  ### [RS256](https://tools.ietf.org/html/rfc7518#section-3.3)  Подпись формируется согласно алгоритму [RSASSA-PKCS1-v1_5](https://tools.ietf.org/html/rfc3447#section-8.2), на вход которому подаётся результат вычисления хэша сообщения по алгоритму [SHA-256](https://tools.ietf.org/html/rfc6234).  Набор атрибутов заголовка и список возможных алгоритмов формирования подписи в дальнейшем могут быть расширены. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@vality.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package dev.vality.swag_webhook_events.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.ClientInfo;
import dev.vality.swag_webhook_events.model.ContactInfo;
import dev.vality.swag_webhook_events.model.CustomerPayer;
import dev.vality.swag_webhook_events.model.Payer;
import dev.vality.swag_webhook_events.model.PaymentResource;
import dev.vality.swag_webhook_events.model.PaymentResourcePayer;
import dev.vality.swag_webhook_events.model.PaymentResourcePayerAllOf;
import dev.vality.swag_webhook_events.model.PaymentToolDetails;
import dev.vality.swag_webhook_events.model.RecurrentPayer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Платежное средство
 */
@ApiModel(description = "Платежное средство")
@JsonPropertyOrder({
  PaymentResourcePayer.JSON_PROPERTY_PAYMENT_TOOL_TOKEN,
  PaymentResourcePayer.JSON_PROPERTY_PAYMENT_SESSION,
  PaymentResourcePayer.JSON_PROPERTY_PAYMENT_TOOL_DETAILS,
  PaymentResourcePayer.JSON_PROPERTY_CLIENT_INFO,
  PaymentResourcePayer.JSON_PROPERTY_CONTACT_INFO
})
@JsonTypeName("PaymentResourcePayer")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-02-11T15:32:13.145223856Z[Etc/UTC]")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "payerType", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = CustomerPayer.class, name = "CustomerPayer"),
  @JsonSubTypes.Type(value = PaymentResourcePayer.class, name = "PaymentResourcePayer"),
  @JsonSubTypes.Type(value = RecurrentPayer.class, name = "RecurrentPayer"),
})

public class PaymentResourcePayer extends Payer {
  public static final String JSON_PROPERTY_PAYMENT_TOOL_TOKEN = "paymentToolToken";
  private String paymentToolToken;

  public static final String JSON_PROPERTY_PAYMENT_SESSION = "paymentSession";
  private String paymentSession;

  public static final String JSON_PROPERTY_PAYMENT_TOOL_DETAILS = "paymentToolDetails";
  private PaymentToolDetails paymentToolDetails;

  public static final String JSON_PROPERTY_CLIENT_INFO = "clientInfo";
  private ClientInfo clientInfo;

  public static final String JSON_PROPERTY_CONTACT_INFO = "contactInfo";
  private ContactInfo contactInfo;

  public PaymentResourcePayer() { 
  }

  public PaymentResourcePayer paymentToolToken(String paymentToolToken) {
    
    this.paymentToolToken = paymentToolToken;
    return this;
  }

   /**
   * Токен платежного средства, предоставленного плательщиком
   * @return paymentToolToken
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Токен платежного средства, предоставленного плательщиком")
  @JsonProperty(JSON_PROPERTY_PAYMENT_TOOL_TOKEN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPaymentToolToken() {
    return paymentToolToken;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_TOOL_TOKEN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPaymentToolToken(String paymentToolToken) {
    this.paymentToolToken = paymentToolToken;
  }


  public PaymentResourcePayer paymentSession(String paymentSession) {
    
    this.paymentSession = paymentSession;
    return this;
  }

   /**
   * Идентификатор платежной сессии
   * @return paymentSession
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Идентификатор платежной сессии")
  @JsonProperty(JSON_PROPERTY_PAYMENT_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPaymentSession() {
    return paymentSession;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPaymentSession(String paymentSession) {
    this.paymentSession = paymentSession;
  }


  public PaymentResourcePayer paymentToolDetails(PaymentToolDetails paymentToolDetails) {
    
    this.paymentToolDetails = paymentToolDetails;
    return this;
  }

   /**
   * Get paymentToolDetails
   * @return paymentToolDetails
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_TOOL_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PaymentToolDetails getPaymentToolDetails() {
    return paymentToolDetails;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_TOOL_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentToolDetails(PaymentToolDetails paymentToolDetails) {
    this.paymentToolDetails = paymentToolDetails;
  }


  public PaymentResourcePayer clientInfo(ClientInfo clientInfo) {
    
    this.clientInfo = clientInfo;
    return this;
  }

   /**
   * Get clientInfo
   * @return clientInfo
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CLIENT_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ClientInfo getClientInfo() {
    return clientInfo;
  }


  @JsonProperty(JSON_PROPERTY_CLIENT_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClientInfo(ClientInfo clientInfo) {
    this.clientInfo = clientInfo;
  }


  public PaymentResourcePayer contactInfo(ContactInfo contactInfo) {
    
    this.contactInfo = contactInfo;
    return this;
  }

   /**
   * Get contactInfo
   * @return contactInfo
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CONTACT_INFO)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ContactInfo getContactInfo() {
    return contactInfo;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_INFO)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContactInfo(ContactInfo contactInfo) {
    this.contactInfo = contactInfo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentResourcePayer paymentResourcePayer = (PaymentResourcePayer) o;
    return Objects.equals(this.paymentToolToken, paymentResourcePayer.paymentToolToken) &&
        Objects.equals(this.paymentSession, paymentResourcePayer.paymentSession) &&
        Objects.equals(this.paymentToolDetails, paymentResourcePayer.paymentToolDetails) &&
        Objects.equals(this.clientInfo, paymentResourcePayer.clientInfo) &&
        Objects.equals(this.contactInfo, paymentResourcePayer.contactInfo) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paymentToolToken, paymentSession, paymentToolDetails, clientInfo, contactInfo, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentResourcePayer {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    paymentToolToken: ").append(toIndentedString(paymentToolToken)).append("\n");
    sb.append("    paymentSession: ").append(toIndentedString(paymentSession)).append("\n");
    sb.append("    paymentToolDetails: ").append(toIndentedString(paymentToolDetails)).append("\n");
    sb.append("    clientInfo: ").append(toIndentedString(clientInfo)).append("\n");
    sb.append("    contactInfo: ").append(toIndentedString(contactInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

