/*
 * Vality Webhooks Events API
 *  ## Webhooks Events API  Данная спецификация определяет протокол доставки оповещений о возникновении новых событий в рамках вашей организации, которые платформа доставляет в виде HTTP-запросов на URL-адреса созданных вами webhook'ов. Обработчики для подобного рода запросов необходимо реализовать на стороне вашего серверного кода согласно данной спецификации.  Webhook — это подписка на определенный тип события либо их группу, касающихся различных объектов в рамках вашей организации. Для управления webhook'ами используются методы Vality API, описанные в спецификации [Vality Webhooks Management API](https://vality.github.io/api#Webhooks). Когда наступает одно из событий в рамках определенного инвойса (например, изменение статуса инвойса или платежа по этому инвойсу), платформа выбирает webhook, подходящий под этот тип события, и отправляет HTTP-запрос, содержащий сообщение в формате JSON на указанный в этом webhook'е URL. Если вы создали несколько webhook'ов, подходящих под этот тип события, то событие доставляется одновременно на все заданные в них URL в неопределённом порядке.  ## Стратегия доставки  Платформа гарантирует порядок доставки событий в рамках определенного инвойса, никакое событие не может быть пропущено и доставлено не в порядке возникновения в платформе. Платформа поддерживает очередь сообщений для каждого инвойса для того, чтобы соблюсти эти гарантии.  Запрос на доставку считается успешным только при получении ответа со статусом `200`. Платформа будет ожидать успешного ответа на отправленный запрос в течение 10 секунд. В случае ответа любым другим статусом или по истечении указанного времени, отведённого на обработку оповещения, платформа будет пытаться повторно доставить оповещения до получения успешного ответа, либо до принятия решения о невозможности доставить информацию. Попытки доставки будут производиться со следующими временными интервалами между запросами:    - 30 секунд,   - 5 минут,   - 15 минут,   - 1 час.   - каждый час в течение суток (24 часа)  Если последняя попытка доставить оповещение оканчивается неудачей, все события, которые накопились в очереди этого инвойса, отбрасываются.  ## Авторизация полученных сообщений  Платформа подтверждает подлинность оповещений, подписывая сообщения приватным ключом, уникальным для каждого webhook'а, парный публичный ключ к которому содержится в данных этого webhook'а. Подпись передается в HTTP-заголовке `Content-Signature`. В заголовке в виде различных атрибутов содержится информация об использованном при формировании подписи алгоритме и значение подписи в формате [URL-safe base-64](https://tools.ietf.org/html/rfc4648).  ``` Content-Signature: alg=RS256; digest=zFuf7bRH4RHwyktaqHQwmX5rn3LfSb4dKo... ```  На данный момент возможно использование единственного алоритма формирования подписи.  ### [RS256](https://tools.ietf.org/html/rfc7518#section-3.3)  Подпись формируется согласно алгоритму [RSASSA-PKCS1-v1_5](https://tools.ietf.org/html/rfc3447#section-8.2), на вход которому подаётся результат вычисления хэша сообщения по алгоритму [SHA-256](https://tools.ietf.org/html/rfc6234).  Набор атрибутов заголовка и список возможных алгоритмов формирования подписи в дальнейшем могут быть расширены. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@vality.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package dev.vality.swag_webhook_events.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.ClientInfo;
import dev.vality.swag_webhook_events.model.PaymentToolDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Данные платежного средства
 */
@ApiModel(description = "Данные платежного средства")
@JsonPropertyOrder({
  PaymentResource.JSON_PROPERTY_PAYMENT_TOOL_TOKEN,
  PaymentResource.JSON_PROPERTY_PAYMENT_SESSION,
  PaymentResource.JSON_PROPERTY_PAYMENT_TOOL_DETAILS,
  PaymentResource.JSON_PROPERTY_CLIENT_INFO
})
@JsonTypeName("PaymentResource")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-02-11T15:32:13.145223856Z[Etc/UTC]")
public class PaymentResource {
  public static final String JSON_PROPERTY_PAYMENT_TOOL_TOKEN = "paymentToolToken";
  private String paymentToolToken;

  public static final String JSON_PROPERTY_PAYMENT_SESSION = "paymentSession";
  private String paymentSession;

  public static final String JSON_PROPERTY_PAYMENT_TOOL_DETAILS = "paymentToolDetails";
  private PaymentToolDetails paymentToolDetails;

  public static final String JSON_PROPERTY_CLIENT_INFO = "clientInfo";
  private ClientInfo clientInfo;

  public PaymentResource() { 
  }

  public PaymentResource paymentToolToken(String paymentToolToken) {
    
    this.paymentToolToken = paymentToolToken;
    return this;
  }

   /**
   * Токен платежного средства, предоставленного плательщиком
   * @return paymentToolToken
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Токен платежного средства, предоставленного плательщиком")
  @JsonProperty(JSON_PROPERTY_PAYMENT_TOOL_TOKEN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPaymentToolToken() {
    return paymentToolToken;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_TOOL_TOKEN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPaymentToolToken(String paymentToolToken) {
    this.paymentToolToken = paymentToolToken;
  }


  public PaymentResource paymentSession(String paymentSession) {
    
    this.paymentSession = paymentSession;
    return this;
  }

   /**
   * Идентификатор платежной сессии
   * @return paymentSession
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Идентификатор платежной сессии")
  @JsonProperty(JSON_PROPERTY_PAYMENT_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPaymentSession() {
    return paymentSession;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPaymentSession(String paymentSession) {
    this.paymentSession = paymentSession;
  }


  public PaymentResource paymentToolDetails(PaymentToolDetails paymentToolDetails) {
    
    this.paymentToolDetails = paymentToolDetails;
    return this;
  }

   /**
   * Get paymentToolDetails
   * @return paymentToolDetails
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_TOOL_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PaymentToolDetails getPaymentToolDetails() {
    return paymentToolDetails;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_TOOL_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentToolDetails(PaymentToolDetails paymentToolDetails) {
    this.paymentToolDetails = paymentToolDetails;
  }


  public PaymentResource clientInfo(ClientInfo clientInfo) {
    
    this.clientInfo = clientInfo;
    return this;
  }

   /**
   * Get clientInfo
   * @return clientInfo
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CLIENT_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ClientInfo getClientInfo() {
    return clientInfo;
  }


  @JsonProperty(JSON_PROPERTY_CLIENT_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClientInfo(ClientInfo clientInfo) {
    this.clientInfo = clientInfo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentResource paymentResource = (PaymentResource) o;
    return Objects.equals(this.paymentToolToken, paymentResource.paymentToolToken) &&
        Objects.equals(this.paymentSession, paymentResource.paymentSession) &&
        Objects.equals(this.paymentToolDetails, paymentResource.paymentToolDetails) &&
        Objects.equals(this.clientInfo, paymentResource.clientInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paymentToolToken, paymentSession, paymentToolDetails, clientInfo);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentResource {\n");
    sb.append("    paymentToolToken: ").append(toIndentedString(paymentToolToken)).append("\n");
    sb.append("    paymentSession: ").append(toIndentedString(paymentSession)).append("\n");
    sb.append("    paymentToolDetails: ").append(toIndentedString(paymentToolDetails)).append("\n");
    sb.append("    clientInfo: ").append(toIndentedString(clientInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

