/*
 * Vality Webhooks Events API
 *  ## Webhooks Events API  Данная спецификация определяет протокол доставки оповещений о возникновении новых событий в рамках вашей организации, которые платформа доставляет в виде HTTP-запросов на URL-адреса созданных вами webhook'ов. Обработчики для подобного рода запросов необходимо реализовать на стороне вашего серверного кода согласно данной спецификации.  Webhook — это подписка на определенный тип события либо их группу, касающихся различных объектов в рамках вашей организации. Для управления webhook'ами используются методы Vality API, описанные в спецификации [Vality Webhooks Management API](https://vality.github.io/api#Webhooks). Когда наступает одно из событий в рамках определенного инвойса (например, изменение статуса инвойса или платежа по этому инвойсу), платформа выбирает webhook, подходящий под этот тип события, и отправляет HTTP-запрос, содержащий сообщение в формате JSON на указанный в этом webhook'е URL. Если вы создали несколько webhook'ов, подходящих под этот тип события, то событие доставляется одновременно на все заданные в них URL в неопределённом порядке.  ## Стратегия доставки  Платформа гарантирует порядок доставки событий в рамках определенного инвойса, никакое событие не может быть пропущено и доставлено не в порядке возникновения в платформе. Платформа поддерживает очередь сообщений для каждого инвойса для того, чтобы соблюсти эти гарантии.  Запрос на доставку считается успешным только при получении ответа со статусом `200`. Платформа будет ожидать успешного ответа на отправленный запрос в течение 10 секунд. В случае ответа любым другим статусом или по истечении указанного времени, отведённого на обработку оповещения, платформа будет пытаться повторно доставить оповещения до получения успешного ответа, либо до принятия решения о невозможности доставить информацию. Попытки доставки будут производиться со следующими временными интервалами между запросами:    - 30 секунд,   - 5 минут,   - 15 минут,   - 1 час.   - каждый час в течение суток (24 часа)  Если последняя попытка доставить оповещение оканчивается неудачей, все события, которые накопились в очереди этого инвойса, отбрасываются.  ## Авторизация полученных сообщений  Платформа подтверждает подлинность оповещений, подписывая сообщения приватным ключом, уникальным для каждого webhook'а, парный публичный ключ к которому содержится в данных этого webhook'а. Подпись передается в HTTP-заголовке `Content-Signature`. В заголовке в виде различных атрибутов содержится информация об использованном при формировании подписи алгоритме и значение подписи в формате [URL-safe base-64](https://tools.ietf.org/html/rfc4648).  ``` Content-Signature: alg=RS256; digest=zFuf7bRH4RHwyktaqHQwmX5rn3LfSb4dKo... ```  На данный момент возможно использование единственного алоритма формирования подписи.  ### [RS256](https://tools.ietf.org/html/rfc7518#section-3.3)  Подпись формируется согласно алгоритму [RSASSA-PKCS1-v1_5](https://tools.ietf.org/html/rfc3447#section-8.2), на вход которому подаётся результат вычисления хэша сообщения по алгоритму [SHA-256](https://tools.ietf.org/html/rfc6234).  Набор атрибутов заголовка и список возможных алгоритмов формирования подписи в дальнейшем могут быть расширены. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@vality.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package dev.vality.swag_webhook_events.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.Customer;
import dev.vality.swag_webhook_events.model.CustomerBinding;
import dev.vality.swag_webhook_events.model.CustomerBindingFailed;
import dev.vality.swag_webhook_events.model.CustomerBindingStarted;
import dev.vality.swag_webhook_events.model.CustomerBindingStartedAllOf;
import dev.vality.swag_webhook_events.model.CustomerBindingSucceeded;
import dev.vality.swag_webhook_events.model.CustomerCreated;
import dev.vality.swag_webhook_events.model.CustomerDeleted;
import dev.vality.swag_webhook_events.model.CustomerReady;
import dev.vality.swag_webhook_events.model.Event;
import dev.vality.swag_webhook_events.model.InvoiceCancelled;
import dev.vality.swag_webhook_events.model.InvoiceCreated;
import dev.vality.swag_webhook_events.model.InvoiceFulfilled;
import dev.vality.swag_webhook_events.model.InvoicePaid;
import dev.vality.swag_webhook_events.model.PaymentCancelled;
import dev.vality.swag_webhook_events.model.PaymentCaptured;
import dev.vality.swag_webhook_events.model.PaymentFailed;
import dev.vality.swag_webhook_events.model.PaymentProcessed;
import dev.vality.swag_webhook_events.model.PaymentRefunded;
import dev.vality.swag_webhook_events.model.PaymentStarted;
import dev.vality.swag_webhook_events.model.RefundCreated;
import dev.vality.swag_webhook_events.model.RefundFailed;
import dev.vality.swag_webhook_events.model.RefundPending;
import dev.vality.swag_webhook_events.model.RefundSucceeded;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Событие о неуспешной привязке плательщика к платежному средству
 */
@ApiModel(description = "Событие о неуспешной привязке плательщика к платежному средству")
@JsonPropertyOrder({
  CustomerBindingFailed.JSON_PROPERTY_CUSTOMER,
  CustomerBindingFailed.JSON_PROPERTY_BINDING
})
@JsonTypeName("CustomerBindingFailed")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-02-11T15:32:13.145223856Z[Etc/UTC]")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "eventType", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = CustomerBindingFailed.class, name = "CustomerBindingFailed"),
  @JsonSubTypes.Type(value = CustomerBindingStarted.class, name = "CustomerBindingStarted"),
  @JsonSubTypes.Type(value = CustomerBindingSucceeded.class, name = "CustomerBindingSucceeded"),
  @JsonSubTypes.Type(value = CustomerCreated.class, name = "CustomerCreated"),
  @JsonSubTypes.Type(value = CustomerDeleted.class, name = "CustomerDeleted"),
  @JsonSubTypes.Type(value = CustomerReady.class, name = "CustomerReady"),
  @JsonSubTypes.Type(value = InvoiceCancelled.class, name = "InvoiceCancelled"),
  @JsonSubTypes.Type(value = InvoiceCreated.class, name = "InvoiceCreated"),
  @JsonSubTypes.Type(value = InvoiceFulfilled.class, name = "InvoiceFulfilled"),
  @JsonSubTypes.Type(value = InvoicePaid.class, name = "InvoicePaid"),
  @JsonSubTypes.Type(value = PaymentCancelled.class, name = "PaymentCancelled"),
  @JsonSubTypes.Type(value = PaymentCaptured.class, name = "PaymentCaptured"),
  @JsonSubTypes.Type(value = PaymentFailed.class, name = "PaymentFailed"),
  @JsonSubTypes.Type(value = PaymentProcessed.class, name = "PaymentProcessed"),
  @JsonSubTypes.Type(value = PaymentRefunded.class, name = "PaymentRefunded"),
  @JsonSubTypes.Type(value = PaymentStarted.class, name = "PaymentStarted"),
  @JsonSubTypes.Type(value = RefundCreated.class, name = "RefundCreated"),
  @JsonSubTypes.Type(value = RefundFailed.class, name = "RefundFailed"),
  @JsonSubTypes.Type(value = RefundPending.class, name = "RefundPending"),
  @JsonSubTypes.Type(value = RefundSucceeded.class, name = "RefundSucceeded"),
})

public class CustomerBindingFailed extends Event {
  public static final String JSON_PROPERTY_CUSTOMER = "customer";
  private Customer customer;

  public static final String JSON_PROPERTY_BINDING = "binding";
  private CustomerBinding binding;

  public CustomerBindingFailed() { 
  }

  public CustomerBindingFailed customer(Customer customer) {
    
    this.customer = customer;
    return this;
  }

   /**
   * Get customer
   * @return customer
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CUSTOMER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Customer getCustomer() {
    return customer;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCustomer(Customer customer) {
    this.customer = customer;
  }


  public CustomerBindingFailed binding(CustomerBinding binding) {
    
    this.binding = binding;
    return this;
  }

   /**
   * Get binding
   * @return binding
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_BINDING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomerBinding getBinding() {
    return binding;
  }


  @JsonProperty(JSON_PROPERTY_BINDING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBinding(CustomerBinding binding) {
    this.binding = binding;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CustomerBindingFailed customerBindingFailed = (CustomerBindingFailed) o;
    return Objects.equals(this.customer, customerBindingFailed.customer) &&
        Objects.equals(this.binding, customerBindingFailed.binding) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customer, binding, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CustomerBindingFailed {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    customer: ").append(toIndentedString(customer)).append("\n");
    sb.append("    binding: ").append(toIndentedString(binding)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

