/*
 * Vality Webhooks Events API
 *  ## Webhooks Events API  Данная спецификация определяет протокол доставки оповещений о возникновении новых событий в рамках вашей организации, которые платформа доставляет в виде HTTP-запросов на URL-адреса созданных вами webhook'ов. Обработчики для подобного рода запросов необходимо реализовать на стороне вашего серверного кода согласно данной спецификации.  Webhook — это подписка на определенный тип события либо их группу, касающихся различных объектов в рамках вашей организации. Для управления webhook'ами используются методы Vality API, описанные в спецификации [Vality Webhooks Management API](https://vality.github.io/api#Webhooks). Когда наступает одно из событий в рамках определенного инвойса (например, изменение статуса инвойса или платежа по этому инвойсу), платформа выбирает webhook, подходящий под этот тип события, и отправляет HTTP-запрос, содержащий сообщение в формате JSON на указанный в этом webhook'е URL. Если вы создали несколько webhook'ов, подходящих под этот тип события, то событие доставляется одновременно на все заданные в них URL в неопределённом порядке.  ## Стратегия доставки  Платформа гарантирует порядок доставки событий в рамках определенного инвойса, никакое событие не может быть пропущено и доставлено не в порядке возникновения в платформе. Платформа поддерживает очередь сообщений для каждого инвойса для того, чтобы соблюсти эти гарантии.  Запрос на доставку считается успешным только при получении ответа со статусом `200`. Платформа будет ожидать успешного ответа на отправленный запрос в течение 10 секунд. В случае ответа любым другим статусом или по истечении указанного времени, отведённого на обработку оповещения, платформа будет пытаться повторно доставить оповещения до получения успешного ответа, либо до принятия решения о невозможности доставить информацию. Попытки доставки будут производиться со следующими временными интервалами между запросами:    - 30 секунд,   - 5 минут,   - 15 минут,   - 1 час.   - каждый час в течение суток (24 часа)  Если последняя попытка доставить оповещение оканчивается неудачей, все события, которые накопились в очереди этого инвойса, отбрасываются.  ## Авторизация полученных сообщений  Платформа подтверждает подлинность оповещений, подписывая сообщения приватным ключом, уникальным для каждого webhook'а, парный публичный ключ к которому содержится в данных этого webhook'а. Подпись передается в HTTP-заголовке `Content-Signature`. В заголовке в виде различных атрибутов содержится информация об использованном при формировании подписи алгоритме и значение подписи в формате [URL-safe base-64](https://tools.ietf.org/html/rfc4648).  ``` Content-Signature: alg=RS256; digest=zFuf7bRH4RHwyktaqHQwmX5rn3LfSb4dKo... ```  На данный момент возможно использование единственного алоритма формирования подписи.  ### [RS256](https://tools.ietf.org/html/rfc7518#section-3.3)  Подпись формируется согласно алгоритму [RSASSA-PKCS1-v1_5](https://tools.ietf.org/html/rfc3447#section-8.2), на вход которому подаётся результат вычисления хэша сообщения по алгоритму [SHA-256](https://tools.ietf.org/html/rfc6234).  Набор атрибутов заголовка и список возможных алгоритмов формирования подписи в дальнейшем могут быть расширены. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@vality.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package dev.vality.swag_webhook_events.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * BankCardDetails
 */
@JsonPropertyOrder({
  BankCardDetails.JSON_PROPERTY_BIN,
  BankCardDetails.JSON_PROPERTY_LAST_DIGITS,
  BankCardDetails.JSON_PROPERTY_CARD_NUMBER_MASK,
  BankCardDetails.JSON_PROPERTY_PAYMENT_SYSTEM,
  BankCardDetails.JSON_PROPERTY_TOKEN_PROVIDER,
  BankCardDetails.JSON_PROPERTY_ISSUER_COUNTRY,
  BankCardDetails.JSON_PROPERTY_BANK_NAME
})
@JsonTypeName("BankCardDetails")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-02-11T15:32:13.145223856Z[Etc/UTC]")
public class BankCardDetails {
  public static final String JSON_PROPERTY_BIN = "bin";
  private String bin;

  public static final String JSON_PROPERTY_LAST_DIGITS = "lastDigits";
  private String lastDigits;

  public static final String JSON_PROPERTY_CARD_NUMBER_MASK = "cardNumberMask";
  private String cardNumberMask;

  public static final String JSON_PROPERTY_PAYMENT_SYSTEM = "paymentSystem";
  private String paymentSystem;

  /**
   * Провайдер платежных токенов
   */
  public enum TokenProviderEnum {
    APPLEPAY("applepay"),
    
    GOOGLEPAY("googlepay"),
    
    SAMSUNGPAY("samsungpay"),
    
    YANDEXPAY("yandexpay");

    private String value;

    TokenProviderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TokenProviderEnum fromValue(String value) {
      for (TokenProviderEnum b : TokenProviderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TOKEN_PROVIDER = "tokenProvider";
  private TokenProviderEnum tokenProvider;

  public static final String JSON_PROPERTY_ISSUER_COUNTRY = "issuerCountry";
  private String issuerCountry;

  public static final String JSON_PROPERTY_BANK_NAME = "bankName";
  private String bankName;

  public BankCardDetails() { 
  }

  public BankCardDetails bin(String bin) {
    
    this.bin = bin;
    return this;
  }

   /**
   * БИН банка-эмитента карты
   * @return bin
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "БИН банка-эмитента карты")
  @JsonProperty(JSON_PROPERTY_BIN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getBin() {
    return bin;
  }


  @JsonProperty(JSON_PROPERTY_BIN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBin(String bin) {
    this.bin = bin;
  }


  public BankCardDetails lastDigits(String lastDigits) {
    
    this.lastDigits = lastDigits;
    return this;
  }

   /**
   * Последние цифры номера карты
   * @return lastDigits
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Последние цифры номера карты")
  @JsonProperty(JSON_PROPERTY_LAST_DIGITS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLastDigits() {
    return lastDigits;
  }


  @JsonProperty(JSON_PROPERTY_LAST_DIGITS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLastDigits(String lastDigits) {
    this.lastDigits = lastDigits;
  }


  public BankCardDetails cardNumberMask(String cardNumberMask) {
    
    this.cardNumberMask = cardNumberMask;
    return this;
  }

   /**
   * Маскированый номер карты
   * @return cardNumberMask
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Маскированый номер карты")
  @JsonProperty(JSON_PROPERTY_CARD_NUMBER_MASK)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCardNumberMask() {
    return cardNumberMask;
  }


  @JsonProperty(JSON_PROPERTY_CARD_NUMBER_MASK)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCardNumberMask(String cardNumberMask) {
    this.cardNumberMask = cardNumberMask;
  }


  public BankCardDetails paymentSystem(String paymentSystem) {
    
    this.paymentSystem = paymentSystem;
    return this;
  }

   /**
   * Платежная система
   * @return paymentSystem
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Платежная система")
  @JsonProperty(JSON_PROPERTY_PAYMENT_SYSTEM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPaymentSystem() {
    return paymentSystem;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_SYSTEM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPaymentSystem(String paymentSystem) {
    this.paymentSystem = paymentSystem;
  }


  public BankCardDetails tokenProvider(TokenProviderEnum tokenProvider) {
    
    this.tokenProvider = tokenProvider;
    return this;
  }

   /**
   * Провайдер платежных токенов
   * @return tokenProvider
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Провайдер платежных токенов")
  @JsonProperty(JSON_PROPERTY_TOKEN_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TokenProviderEnum getTokenProvider() {
    return tokenProvider;
  }


  @JsonProperty(JSON_PROPERTY_TOKEN_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTokenProvider(TokenProviderEnum tokenProvider) {
    this.tokenProvider = tokenProvider;
  }


  public BankCardDetails issuerCountry(String issuerCountry) {
    
    this.issuerCountry = issuerCountry;
    return this;
  }

   /**
   * Страна эмитент (alpha-3 код по стандарту ISO_3166-1)
   * @return issuerCountry
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"RUS\",\"POL\",\"USA\"]", value = "Страна эмитент (alpha-3 код по стандарту ISO_3166-1)")
  @JsonProperty(JSON_PROPERTY_ISSUER_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIssuerCountry() {
    return issuerCountry;
  }


  @JsonProperty(JSON_PROPERTY_ISSUER_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssuerCountry(String issuerCountry) {
    this.issuerCountry = issuerCountry;
  }


  public BankCardDetails bankName(String bankName) {
    
    this.bankName = bankName;
    return this;
  }

   /**
   * Наименование банка
   * @return bankName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"SBERBANK OF RUSSIA\",\"JOINT STOCK COMPANY ALFA-BANK\",\"VTB BANK OJSC\"]", value = "Наименование банка")
  @JsonProperty(JSON_PROPERTY_BANK_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBankName() {
    return bankName;
  }


  @JsonProperty(JSON_PROPERTY_BANK_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankName(String bankName) {
    this.bankName = bankName;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BankCardDetails bankCardDetails = (BankCardDetails) o;
    return Objects.equals(this.bin, bankCardDetails.bin) &&
        Objects.equals(this.lastDigits, bankCardDetails.lastDigits) &&
        Objects.equals(this.cardNumberMask, bankCardDetails.cardNumberMask) &&
        Objects.equals(this.paymentSystem, bankCardDetails.paymentSystem) &&
        Objects.equals(this.tokenProvider, bankCardDetails.tokenProvider) &&
        Objects.equals(this.issuerCountry, bankCardDetails.issuerCountry) &&
        Objects.equals(this.bankName, bankCardDetails.bankName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bin, lastDigits, cardNumberMask, paymentSystem, tokenProvider, issuerCountry, bankName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BankCardDetails {\n");
    sb.append("    bin: ").append(toIndentedString(bin)).append("\n");
    sb.append("    lastDigits: ").append(toIndentedString(lastDigits)).append("\n");
    sb.append("    cardNumberMask: ").append(toIndentedString(cardNumberMask)).append("\n");
    sb.append("    paymentSystem: ").append(toIndentedString(paymentSystem)).append("\n");
    sb.append("    tokenProvider: ").append(toIndentedString(tokenProvider)).append("\n");
    sb.append("    issuerCountry: ").append(toIndentedString(issuerCountry)).append("\n");
    sb.append("    bankName: ").append(toIndentedString(bankName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

