/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag.wallets.webhook.events.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.wallets.webhook.events.model.DestinationAuthorized;
import dev.vality.swag.wallets.webhook.events.model.DestinationCreated;
import dev.vality.swag.wallets.webhook.events.model.DestinationUnauthorized;
import dev.vality.swag.wallets.webhook.events.model.WithdrawalFailed;
import dev.vality.swag.wallets.webhook.events.model.WithdrawalStarted;
import dev.vality.swag.wallets.webhook.events.model.WithdrawalSucceeded;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.format.annotation.DateTimeFormat;

@Schema(name="Event", description="Event data")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="eventType", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=DestinationAuthorized.class, name="DestinationAuthorized"), @JsonSubTypes.Type(value=DestinationCreated.class, name="DestinationCreated"), @JsonSubTypes.Type(value=DestinationUnauthorized.class, name="DestinationUnauthorized"), @JsonSubTypes.Type(value=WithdrawalFailed.class, name="WithdrawalFailed"), @JsonSubTypes.Type(value=WithdrawalStarted.class, name="WithdrawalStarted"), @JsonSubTypes.Type(value=WithdrawalSucceeded.class, name="WithdrawalSucceeded")})
public class Event {
    @JsonProperty(value="eventID")
    private String eventID;
    @JsonProperty(value="occuredAt")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime occuredAt;
    @JsonProperty(value="topic")
    private TopicEnum topic;
    @JsonProperty(value="eventType")
    private EventTypeEnum eventType;

    public Event eventID(String eventID) {
        this.eventID = eventID;
        return this;
    }

    @Schema(name="eventID", description="Event identifier", required=false)
    public String getEventID() {
        return this.eventID;
    }

    public void setEventID(String eventID) {
        this.eventID = eventID;
    }

    public Event occuredAt(OffsetDateTime occuredAt) {
        this.occuredAt = occuredAt;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="occuredAt", description="Date and time the event occurrence", required=true)
    public OffsetDateTime getOccuredAt() {
        return this.occuredAt;
    }

    public void setOccuredAt(OffsetDateTime occuredAt) {
        this.occuredAt = occuredAt;
    }

    public Event topic(TopicEnum topic) {
        this.topic = topic;
        return this;
    }

    @NotNull
    @Schema(name="topic", description="Subject of notification", required=true)
    public TopicEnum getTopic() {
        return this.topic;
    }

    public void setTopic(TopicEnum topic) {
        this.topic = topic;
    }

    public Event eventType(EventTypeEnum eventType) {
        this.eventType = eventType;
        return this;
    }

    @NotNull
    @Schema(name="eventType", description="Type of event that occurred", required=true)
    public EventTypeEnum getEventType() {
        return this.eventType;
    }

    public void setEventType(EventTypeEnum eventType) {
        this.eventType = eventType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return Objects.equals(this.eventID, event.eventID) && Objects.equals(this.occuredAt, event.occuredAt) && Objects.equals((Object)this.topic, (Object)event.topic) && Objects.equals((Object)this.eventType, (Object)event.eventType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventID, this.occuredAt, this.topic, this.eventType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Event {\n");
        sb.append("    eventID: ").append(this.toIndentedString(this.eventID)).append("\n");
        sb.append("    occuredAt: ").append(this.toIndentedString(this.occuredAt)).append("\n");
        sb.append("    topic: ").append(this.toIndentedString((Object)this.topic)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TopicEnum {
        WITHDRAWALTOPIC("WithdrawalTopic"),
        DESTINATIONTOPIC("DestinationTopic");

        private String value;

        private TopicEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TopicEnum fromValue(String value) {
            for (TopicEnum b : TopicEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum EventTypeEnum {
        WITHDRAWALSTARTED("WithdrawalStarted"),
        WITHDRAWALSUCCEEDED("WithdrawalSucceeded"),
        WITHDRAWALFAILED("WithdrawalFailed"),
        DESTINATIONCREATED("DestinationCreated"),
        DESTINATIONAUTHORIZED("DestinationAuthorized"),
        DESTINATIONUNAUTHORIZED("DestinationUnauthorized");

        private String value;

        private EventTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EventTypeEnum fromValue(String value) {
            for (EventTypeEnum b : EventTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

