/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag.wallets.webhook.events.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.vality.swag.wallets.webhook.events.model.CryptoCurrency;
import dev.vality.swag.wallets.webhook.events.model.DestinationResource;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Schema(name="CryptoWallet", description="Cryptocurrency wallet details")
public class CryptoWallet
extends DestinationResource {
    @JsonProperty(value="cryptoWalletId")
    private String cryptoWalletId;
    @JsonProperty(value="currency")
    private CryptoCurrency currency;

    public CryptoWallet cryptoWalletId(String cryptoWalletId) {
        this.cryptoWalletId = cryptoWalletId;
        return this;
    }

    @NotNull
    @Size(min=16, max=256)
    @Schema(name="cryptoWalletId", example="zu3TcwGI71Bpaaw2XkLWZXlhMdn4zpVzMQ", description="Identifier (aka address) of a cryptocurrency wallet", required=true)
    public @NotNull @Size(min=16, max=256) String getCryptoWalletId() {
        return this.cryptoWalletId;
    }

    public void setCryptoWalletId(String cryptoWalletId) {
        this.cryptoWalletId = cryptoWalletId;
    }

    public CryptoWallet currency(CryptoCurrency currency) {
        this.currency = currency;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="currency", required=true)
    public CryptoCurrency getCurrency() {
        return this.currency;
    }

    public void setCurrency(CryptoCurrency currency) {
        this.currency = currency;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CryptoWallet cryptoWallet = (CryptoWallet)o;
        return Objects.equals(this.cryptoWalletId, cryptoWallet.cryptoWalletId) && Objects.equals((Object)this.currency, (Object)cryptoWallet.currency) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.cryptoWalletId, this.currency, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CryptoWallet {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    cryptoWalletId: ").append(this.toIndentedString(this.cryptoWalletId)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString((Object)this.currency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

