/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag.wallets.webhook.events.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.vality.swag.wallets.webhook.events.model.BankCardTokenProvider;
import dev.vality.swag.wallets.webhook.events.model.DestinationResource;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@Schema(name="BankCard", description="Bank card details")
public class BankCard
extends DestinationResource {
    @JsonProperty(value="cardNumberMask")
    private String cardNumberMask;
    @JsonProperty(value="bin")
    private String bin;
    @JsonProperty(value="lastDigits")
    private String lastDigits;
    @JsonProperty(value="paymentSystem")
    private String paymentSystem;
    @JsonProperty(value="tokenProvider")
    private BankCardTokenProvider tokenProvider;

    public BankCard cardNumberMask(String cardNumberMask) {
        this.cardNumberMask = cardNumberMask;
        return this;
    }

    @NotNull
    @Pattern(regexp="^\\d{6,8}\\*+\\d{2,4}$")
    @Schema(name="cardNumberMask", description="Masked card number", required=true)
    public @NotNull @Pattern(regexp="^\\d{6,8}\\*+\\d{2,4}$") String getCardNumberMask() {
        return this.cardNumberMask;
    }

    public void setCardNumberMask(String cardNumberMask) {
        this.cardNumberMask = cardNumberMask;
    }

    public BankCard bin(String bin) {
        this.bin = bin;
        return this;
    }

    @Pattern(regexp="^\\d{6,8}$")
    @Schema(name="bin", description="Card issuing bank BIN", required=false)
    public @Pattern(regexp="^\\d{6,8}$") String getBin() {
        return this.bin;
    }

    public void setBin(String bin) {
        this.bin = bin;
    }

    public BankCard lastDigits(String lastDigits) {
        this.lastDigits = lastDigits;
        return this;
    }

    @Pattern(regexp="^\\d{2,4}$")
    @Schema(name="lastDigits", description="Card last digits", required=false)
    public @Pattern(regexp="^\\d{2,4}$") String getLastDigits() {
        return this.lastDigits;
    }

    public void setLastDigits(String lastDigits) {
        this.lastDigits = lastDigits;
    }

    public BankCard paymentSystem(String paymentSystem) {
        this.paymentSystem = paymentSystem;
        return this;
    }

    @NotNull
    @Schema(name="paymentSystem", description="Payment system", required=true)
    public String getPaymentSystem() {
        return this.paymentSystem;
    }

    public void setPaymentSystem(String paymentSystem) {
        this.paymentSystem = paymentSystem;
    }

    public BankCard tokenProvider(BankCardTokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
        return this;
    }

    @Valid
    @Schema(name="tokenProvider", required=false)
    public BankCardTokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    public void setTokenProvider(BankCardTokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankCard bankCard = (BankCard)o;
        return Objects.equals(this.cardNumberMask, bankCard.cardNumberMask) && Objects.equals(this.bin, bankCard.bin) && Objects.equals(this.lastDigits, bankCard.lastDigits) && Objects.equals(this.paymentSystem, bankCard.paymentSystem) && Objects.equals((Object)this.tokenProvider, (Object)bankCard.tokenProvider) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.cardNumberMask, this.bin, this.lastDigits, this.paymentSystem, this.tokenProvider, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankCard {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    cardNumberMask: ").append(this.toIndentedString(this.cardNumberMask)).append("\n");
        sb.append("    bin: ").append(this.toIndentedString(this.bin)).append("\n");
        sb.append("    lastDigits: ").append(this.toIndentedString(this.lastDigits)).append("\n");
        sb.append("    paymentSystem: ").append(this.toIndentedString(this.paymentSystem)).append("\n");
        sb.append("    tokenProvider: ").append(this.toIndentedString((Object)this.tokenProvider)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

