/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag.wallets.webhook.events.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import dev.vality.swag.wallets.webhook.events.model.WithdrawalBody;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Funds withdrawal data")
@JsonPropertyOrder(value={"id", "createdAt", "destination", "body", "metadata", "wallet", "externalID"})
@JsonTypeName(value="Withdrawal")
public class Withdrawal {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_DESTINATION = "destination";
    private String destination;
    public static final String JSON_PROPERTY_BODY = "body";
    private WithdrawalBody body;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private JsonNullable<Object> metadata = JsonNullable.of(null);
    public static final String JSON_PROPERTY_WALLET = "wallet";
    private String wallet;
    public static final String JSON_PROPERTY_EXTERNAL_I_D = "externalID";
    private String externalID;

    public Withdrawal id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="tZ0jUmlsV0", value="Identifier of funds withdrawal")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public Withdrawal createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date and time the withdrawal started")
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Withdrawal destination(String destination) {
        this.destination = destination;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="10ASF74D98", required=true, value="Destination identifier")
    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDestination() {
        return this.destination;
    }

    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDestination(String destination) {
        this.destination = destination;
    }

    public Withdrawal body(WithdrawalBody body) {
        this.body = body;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="body")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public WithdrawalBody getBody() {
        return this.body;
    }

    @JsonProperty(value="body")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBody(WithdrawalBody body) {
        this.body = body;
    }

    public Withdrawal metadata(Object metadata) {
        this.metadata = JsonNullable.of((Object)metadata);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A custom client-specific API and a data set that is not transparent to the system, associated with this withdrawal ")
    @JsonIgnore
    public Object getMetadata() {
        return this.metadata.orElse(null);
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Object> getMetadata_JsonNullable() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata_JsonNullable(JsonNullable<Object> metadata) {
        this.metadata = metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = JsonNullable.of((Object)metadata);
    }

    public Withdrawal wallet(String wallet) {
        this.wallet = wallet;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="10068321", required=true, value="Identifier of the wallet")
    @JsonProperty(value="wallet")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getWallet() {
        return this.wallet;
    }

    @JsonProperty(value="wallet")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setWallet(String wallet) {
        this.wallet = wallet;
    }

    public Withdrawal externalID(String externalID) {
        this.externalID = externalID;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10036274", value="The unique identifier of the content on your side.  When specified, will be used to ensure idempotent processing of the operation. ")
    @JsonProperty(value="externalID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalID() {
        return this.externalID;
    }

    @JsonProperty(value="externalID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalID(String externalID) {
        this.externalID = externalID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Withdrawal withdrawal = (Withdrawal)o;
        return Objects.equals(this.id, withdrawal.id) && Objects.equals(this.createdAt, withdrawal.createdAt) && Objects.equals(this.destination, withdrawal.destination) && Objects.equals(this.body, withdrawal.body) && Withdrawal.equalsNullable(this.metadata, withdrawal.metadata) && Objects.equals(this.wallet, withdrawal.wallet) && Objects.equals(this.externalID, withdrawal.externalID);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.destination, this.body, Withdrawal.hashCodeNullable(this.metadata), this.wallet, this.externalID);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Withdrawal {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    wallet: ").append(this.toIndentedString(this.wallet)).append("\n");
        sb.append("    externalID: ").append(this.toIndentedString(this.externalID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

