/*
 * Vality Wallets. Webhooks Events API
 *  ## Wallet Webhook Events API The specification defines a protocol for delivering notifications about new wallet events within your organisation. The notifications are deliveried by the system as HTTP requests to the URL of webhooks you created. Handlers for such kind of queries should be implemented on the side of your server code according to the specification.  Webhook is a subscription to a specific type of event or group of events relating to different objects within your organisation. API methods described in the specification [Vality Webhook Management API](https:/github.com/valitydev/swag-wallets) are used to manage webhooks.  When within the wallet one of the events occurs (e.g. a wallet status change), the system selects a webhook matching that event type and sends an HTTP request containing a JSON message to the URL specified in the webhook. If several webhooks matching this event type were created, the event is simultaneously delivered to all URLs specified in those webhooks in an undefined order. ## Delivery strategy The system guarantees events delivery order within a specific notification subject (wallet, deposit, withdrawal, etc.). The system maintains a message queue for each notification item to keep the sequence and ensure the guaranteed delivery.  A delivery request is considered to be successful only when a response with status `200` is received. The system will wait for a successful response to the sent a request during 10 seconds. In case of a response with any other status or after expiration of the specified time which was reserved to process the notification, the system will try to re-deliver notifications until a successful response is received, or until a decision is made that it is impossible to deliver information. Delivery attempts will be made at the following time intervals between requests:    - 30 seconds,   - 5 minutes,   - 15 minutes,   - 1 hour.   - every hour within 24 hours  If the last attempt of notification delivery fails, all the events that have been accumulated in this wallet queue are discarded. ## Received messages authorization The system confirms notifications authenticity by signing messages with a private key that is unique to each webhook, the paired public key of which is contained in the data of that webhook. The signature is transmitted in the HTTP header Content-Signature. Represented in various atributes the header contains the information about the algorithm used to create a signature and content of the signature in the format [URL-safe base-64](https://tools.ietf.org/html/rfc4648).  ``` Content-Signature: alg=RS256; digest=zFuf7bRH4RHwyktaqHQwmX5rn3LfSb4dKo... ```  At the moment the only one signature generation algorithm is possible to use. ### [RS256](https://tools.ietf.org/html/rfc7518#section-3.3) The signature is generated according to [RSASSA-PKCS1-v1_5](https://tools.ietf.org/html/rfc3447#section-8.2) algorithm , which itself uses result of message [SHA-256](https://tools.ietf.org/html/rfc6234) calculation.  The set of header attributes and the list of possible signature generation algorithms can be expanded later. 
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package dev.vality.swag.wallets.webhook.events.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.wallets.webhook.events.model.DestinationAuthorized;
import dev.vality.swag.wallets.webhook.events.model.DestinationCreated;
import dev.vality.swag.wallets.webhook.events.model.DestinationUnauthorized;
import dev.vality.swag.wallets.webhook.events.model.Event;
import dev.vality.swag.wallets.webhook.events.model.Withdrawal;
import dev.vality.swag.wallets.webhook.events.model.WithdrawalFailed;
import dev.vality.swag.wallets.webhook.events.model.WithdrawalStarted;
import dev.vality.swag.wallets.webhook.events.model.WithdrawalStartedAllOf;
import dev.vality.swag.wallets.webhook.events.model.WithdrawalSucceeded;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Withdrawal start event
 */
@ApiModel(description = "Withdrawal start event")
@JsonPropertyOrder({
  WithdrawalStarted.JSON_PROPERTY_WITHDRAWAL
})
@JsonTypeName("WithdrawalStarted")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-13T03:27:19.203054281Z[Etc/UTC]")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "eventType", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = DestinationAuthorized.class, name = "DestinationAuthorized"),
  @JsonSubTypes.Type(value = DestinationCreated.class, name = "DestinationCreated"),
  @JsonSubTypes.Type(value = DestinationUnauthorized.class, name = "DestinationUnauthorized"),
  @JsonSubTypes.Type(value = WithdrawalFailed.class, name = "WithdrawalFailed"),
  @JsonSubTypes.Type(value = WithdrawalStarted.class, name = "WithdrawalStarted"),
  @JsonSubTypes.Type(value = WithdrawalSucceeded.class, name = "WithdrawalSucceeded"),
})

public class WithdrawalStarted extends Event {
  public static final String JSON_PROPERTY_WITHDRAWAL = "withdrawal";
  private Withdrawal withdrawal;

  public WithdrawalStarted() { 
  }

  public WithdrawalStarted withdrawal(Withdrawal withdrawal) {
    
    this.withdrawal = withdrawal;
    return this;
  }

   /**
   * Get withdrawal
   * @return withdrawal
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_WITHDRAWAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Withdrawal getWithdrawal() {
    return withdrawal;
  }


  @JsonProperty(JSON_PROPERTY_WITHDRAWAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setWithdrawal(Withdrawal withdrawal) {
    this.withdrawal = withdrawal;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WithdrawalStarted withdrawalStarted = (WithdrawalStarted) o;
    return Objects.equals(this.withdrawal, withdrawalStarted.withdrawal) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(withdrawal, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WithdrawalStarted {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    withdrawal: ").append(toIndentedString(withdrawal)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

