package dev.vality.swag.wallets.webhook.events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.wallets.webhook.events.model.BankCardAllOf;
import dev.vality.swag.wallets.webhook.events.model.BankCardTokenProvider;
import dev.vality.swag.wallets.webhook.events.model.DestinationResource;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Bank card details
 */

@Schema(name = "BankCard", description = "Bank card details")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-12-24T09:03:16.651030963Z[Etc/UTC]")
public class BankCard extends DestinationResource  {

  @JsonProperty("cardNumberMask")
  private String cardNumberMask;

  @JsonProperty("bin")
  private String bin;

  @JsonProperty("lastDigits")
  private String lastDigits;

  @JsonProperty("paymentSystem")
  private String paymentSystem;

  @JsonProperty("tokenProvider")
  private BankCardTokenProvider tokenProvider;

  public BankCard cardNumberMask(String cardNumberMask) {
    this.cardNumberMask = cardNumberMask;
    return this;
  }

  /**
   * Masked card number
   * @return cardNumberMask
  */
  @NotNull @Pattern(regexp = "^\\d{6,8}\\*+\\d{2,4}$") 
  @Schema(name = "cardNumberMask", description = "Masked card number", required = true)
  public String getCardNumberMask() {
    return cardNumberMask;
  }

  public void setCardNumberMask(String cardNumberMask) {
    this.cardNumberMask = cardNumberMask;
  }

  public BankCard bin(String bin) {
    this.bin = bin;
    return this;
  }

  /**
   * Card issuing bank BIN
   * @return bin
  */
  @Pattern(regexp = "^\\d{6,8}$") 
  @Schema(name = "bin", description = "Card issuing bank BIN", required = false)
  public String getBin() {
    return bin;
  }

  public void setBin(String bin) {
    this.bin = bin;
  }

  public BankCard lastDigits(String lastDigits) {
    this.lastDigits = lastDigits;
    return this;
  }

  /**
   * Card last digits
   * @return lastDigits
  */
  @Pattern(regexp = "^\\d{2,4}$") 
  @Schema(name = "lastDigits", description = "Card last digits", required = false)
  public String getLastDigits() {
    return lastDigits;
  }

  public void setLastDigits(String lastDigits) {
    this.lastDigits = lastDigits;
  }

  public BankCard paymentSystem(String paymentSystem) {
    this.paymentSystem = paymentSystem;
    return this;
  }

  /**
   * Payment system
   * @return paymentSystem
  */
  @NotNull 
  @Schema(name = "paymentSystem", description = "Payment system", required = true)
  public String getPaymentSystem() {
    return paymentSystem;
  }

  public void setPaymentSystem(String paymentSystem) {
    this.paymentSystem = paymentSystem;
  }

  public BankCard tokenProvider(BankCardTokenProvider tokenProvider) {
    this.tokenProvider = tokenProvider;
    return this;
  }

  /**
   * Get tokenProvider
   * @return tokenProvider
  */
  @Valid 
  @Schema(name = "tokenProvider", required = false)
  public BankCardTokenProvider getTokenProvider() {
    return tokenProvider;
  }

  public void setTokenProvider(BankCardTokenProvider tokenProvider) {
    this.tokenProvider = tokenProvider;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BankCard bankCard = (BankCard) o;
    return Objects.equals(this.cardNumberMask, bankCard.cardNumberMask) &&
        Objects.equals(this.bin, bankCard.bin) &&
        Objects.equals(this.lastDigits, bankCard.lastDigits) &&
        Objects.equals(this.paymentSystem, bankCard.paymentSystem) &&
        Objects.equals(this.tokenProvider, bankCard.tokenProvider) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cardNumberMask, bin, lastDigits, paymentSystem, tokenProvider, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BankCard {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    cardNumberMask: ").append(toIndentedString(cardNumberMask)).append("\n");
    sb.append("    bin: ").append(toIndentedString(bin)).append("\n");
    sb.append("    lastDigits: ").append(toIndentedString(lastDigits)).append("\n");
    sb.append("    paymentSystem: ").append(toIndentedString(paymentSystem)).append("\n");
    sb.append("    tokenProvider: ").append(toIndentedString(tokenProvider)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

