/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag.wallets.webhook.events.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.vality.swag.wallets.webhook.events.model.DestinationResource;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@Schema(name="Destination", description="Destination data")
public class Destination {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="identity")
    private String identity;
    @JsonProperty(value="currency")
    private String currency;
    @JsonProperty(value="resource")
    private DestinationResource resource;
    @JsonProperty(value="metadata")
    private Object metadata;
    @JsonProperty(value="externalID")
    private String externalID;

    public Destination id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", example="10ASF74D98", description="Destination identifier", required=false)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Destination name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(name="name", example="Squarey plastic thingy", description="A human-readable name for the receiver by which it is easily recognizable ", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Destination identity(String identity) {
        this.identity = identity;
        return this;
    }

    @NotNull
    @Schema(name="identity", example="tZ0jUmlsV0", description="Identifier of wallet owner", required=true)
    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public Destination currency(String currency) {
        this.currency = currency;
        return this;
    }

    @NotNull
    @Pattern(regexp="^[A-Z]{3}$")
    @Schema(name="currency", example="RUB", description="Currency, character code according to [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). ", required=true)
    public @NotNull @Pattern(regexp="^[A-Z]{3}$") String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Destination resource(DestinationResource resource) {
        this.resource = resource;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="resource", required=true)
    public DestinationResource getResource() {
        return this.resource;
    }

    public void setResource(DestinationResource resource) {
        this.resource = resource;
    }

    public Destination metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @Schema(name="metadata", example="{\"color_hint\":\"olive-green\"}", description="An arbitrary, client-specific API and non-transparent set of data associated with given receiver ", required=false)
    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public Destination externalID(String externalID) {
        this.externalID = externalID;
        return this;
    }

    @Schema(name="externalID", example="10036274", description="The unique identifier of the content on your side.  When specified, will be used to ensure idempotent processing of the operation. ", required=false)
    public String getExternalID() {
        return this.externalID;
    }

    public void setExternalID(String externalID) {
        this.externalID = externalID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Destination destination = (Destination)o;
        return Objects.equals(this.id, destination.id) && Objects.equals(this.name, destination.name) && Objects.equals(this.identity, destination.identity) && Objects.equals(this.currency, destination.currency) && Objects.equals(this.resource, destination.resource) && Objects.equals(this.metadata, destination.metadata) && Objects.equals(this.externalID, destination.externalID);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.identity, this.currency, this.resource, this.metadata, this.externalID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Destination {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    identity: ").append(this.toIndentedString(this.identity)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    externalID: ").append(this.toIndentedString(this.externalID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

