package dev.vality.swag.wallets.webhook.events.api;

import dev.vality.swag.wallets.webhook.events.model.Event;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

/**
 * A delegate to be called by the {@link WebhookApiController}}.
 * Implement this interface with a {@link org.springframework.stereotype.Service} annotated class.
 */
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-11-29T05:23:45.226515518Z[Etc/UTC]")
public interface WebhookApiDelegate {

    default Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    /**
     * POST /webhook : Notify of an event
     *
     * @param contentSignature Message signature formed according to the above rules  (required)
     * @param event Data from an event that occurred in the platform (required)
     * @return Notification processed (status code 200)
     * @see WebhookApi#notifyWebhookEvent
     */
    default ResponseEntity<Void> notifyWebhookEvent(String contentSignature,
        Event event) {
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

}
