/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag.wallets.webhook.events.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.vality.swag.wallets.webhook.events.model.WithdrawalBody;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openapitools.jackson.nullable.JsonNullable;
import org.springframework.format.annotation.DateTimeFormat;

@Schema(name="Withdrawal", description="Funds withdrawal data")
public class Withdrawal {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="createdAt")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime createdAt;
    @JsonProperty(value="destination")
    private String destination;
    @JsonProperty(value="body")
    private WithdrawalBody body;
    @JsonProperty(value="metadata")
    private JsonNullable<Object> metadata = JsonNullable.undefined();
    @JsonProperty(value="wallet")
    private String wallet;
    @JsonProperty(value="externalID")
    private String externalID;

    public Withdrawal id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", example="tZ0jUmlsV0", description="Identifier of funds withdrawal", required=false)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Withdrawal createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Valid
    @Schema(name="createdAt", description="Date and time the withdrawal started", required=false)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Withdrawal destination(String destination) {
        this.destination = destination;
        return this;
    }

    @NotNull
    @Schema(name="destination", example="10ASF74D98", description="Destination identifier", required=true)
    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public Withdrawal body(WithdrawalBody body) {
        this.body = body;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="body", required=true)
    public WithdrawalBody getBody() {
        return this.body;
    }

    public void setBody(WithdrawalBody body) {
        this.body = body;
    }

    public Withdrawal metadata(Object metadata) {
        this.metadata = JsonNullable.of((Object)metadata);
        return this;
    }

    @Schema(name="metadata", description="A custom client-specific API and a data set that is not transparent to the system, associated with this withdrawal ", required=false)
    public JsonNullable<Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(JsonNullable<Object> metadata) {
        this.metadata = metadata;
    }

    public Withdrawal wallet(String wallet) {
        this.wallet = wallet;
        return this;
    }

    @NotNull
    @Schema(name="wallet", example="10068321", description="Identifier of the wallet", required=true)
    public String getWallet() {
        return this.wallet;
    }

    public void setWallet(String wallet) {
        this.wallet = wallet;
    }

    public Withdrawal externalID(String externalID) {
        this.externalID = externalID;
        return this;
    }

    @Schema(name="externalID", example="10036274", description="The unique identifier of the content on your side.  When specified, will be used to ensure idempotent processing of the operation. ", required=false)
    public String getExternalID() {
        return this.externalID;
    }

    public void setExternalID(String externalID) {
        this.externalID = externalID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Withdrawal withdrawal = (Withdrawal)o;
        return Objects.equals(this.id, withdrawal.id) && Objects.equals(this.createdAt, withdrawal.createdAt) && Objects.equals(this.destination, withdrawal.destination) && Objects.equals(this.body, withdrawal.body) && Objects.equals(this.metadata, withdrawal.metadata) && Objects.equals(this.wallet, withdrawal.wallet) && Objects.equals(this.externalID, withdrawal.externalID);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.destination, this.body, this.metadata, this.wallet, this.externalID);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Withdrawal {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    wallet: ").append(this.toIndentedString(this.wallet)).append("\n");
        sb.append("    externalID: ").append(this.toIndentedString(this.externalID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

