package dev.vality.swag.wallets.webhook.events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Event data
 */

@Schema(name = "Event", description = "Event data")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "eventType", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = DestinationAuthorized.class, name = "DestinationAuthorized"),
  @JsonSubTypes.Type(value = DestinationCreated.class, name = "DestinationCreated"),
  @JsonSubTypes.Type(value = DestinationUnauthorized.class, name = "DestinationUnauthorized"),
  @JsonSubTypes.Type(value = WithdrawalFailed.class, name = "WithdrawalFailed"),
  @JsonSubTypes.Type(value = WithdrawalStarted.class, name = "WithdrawalStarted"),
  @JsonSubTypes.Type(value = WithdrawalSucceeded.class, name = "WithdrawalSucceeded"),
})
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-11-16T04:27:59.845708885Z[Etc/UTC]")
public class Event   {

  @JsonProperty("eventID")
  private String eventID;

  @JsonProperty("occuredAt")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime occuredAt;

  /**
   * Subject of notification
   */
  public enum TopicEnum {
    WITHDRAWALTOPIC("WithdrawalTopic"),
    
    DESTINATIONTOPIC("DestinationTopic");

    private String value;

    TopicEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TopicEnum fromValue(String value) {
      for (TopicEnum b : TopicEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("topic")
  private TopicEnum topic;

  /**
   * Type of event that occurred
   */
  public enum EventTypeEnum {
    WITHDRAWALSTARTED("WithdrawalStarted"),
    
    WITHDRAWALSUCCEEDED("WithdrawalSucceeded"),
    
    WITHDRAWALFAILED("WithdrawalFailed"),
    
    DESTINATIONCREATED("DestinationCreated"),
    
    DESTINATIONAUTHORIZED("DestinationAuthorized"),
    
    DESTINATIONUNAUTHORIZED("DestinationUnauthorized");

    private String value;

    EventTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static EventTypeEnum fromValue(String value) {
      for (EventTypeEnum b : EventTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("eventType")
  private EventTypeEnum eventType;

  public Event eventID(String eventID) {
    this.eventID = eventID;
    return this;
  }

  /**
   * Event identifier
   * @return eventID
  */
  
  @Schema(name = "eventID", description = "Event identifier", required = false)
  public String getEventID() {
    return eventID;
  }

  public void setEventID(String eventID) {
    this.eventID = eventID;
  }

  public Event occuredAt(OffsetDateTime occuredAt) {
    this.occuredAt = occuredAt;
    return this;
  }

  /**
   * Date and time the event occurrence
   * @return occuredAt
  */
  @NotNull @Valid 
  @Schema(name = "occuredAt", description = "Date and time the event occurrence", required = true)
  public OffsetDateTime getOccuredAt() {
    return occuredAt;
  }

  public void setOccuredAt(OffsetDateTime occuredAt) {
    this.occuredAt = occuredAt;
  }

  public Event topic(TopicEnum topic) {
    this.topic = topic;
    return this;
  }

  /**
   * Subject of notification
   * @return topic
  */
  @NotNull 
  @Schema(name = "topic", description = "Subject of notification", required = true)
  public TopicEnum getTopic() {
    return topic;
  }

  public void setTopic(TopicEnum topic) {
    this.topic = topic;
  }

  public Event eventType(EventTypeEnum eventType) {
    this.eventType = eventType;
    return this;
  }

  /**
   * Type of event that occurred
   * @return eventType
  */
  @NotNull 
  @Schema(name = "eventType", description = "Type of event that occurred", required = true)
  public EventTypeEnum getEventType() {
    return eventType;
  }

  public void setEventType(EventTypeEnum eventType) {
    this.eventType = eventType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Event event = (Event) o;
    return Objects.equals(this.eventID, event.eventID) &&
        Objects.equals(this.occuredAt, event.occuredAt) &&
        Objects.equals(this.topic, event.topic) &&
        Objects.equals(this.eventType, event.eventType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(eventID, occuredAt, topic, eventType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Event {\n");
    sb.append("    eventID: ").append(toIndentedString(eventID)).append("\n");
    sb.append("    occuredAt: ").append(toIndentedString(occuredAt)).append("\n");
    sb.append("    topic: ").append(toIndentedString(topic)).append("\n");
    sb.append("    eventType: ").append(toIndentedString(eventType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

