/*
 * Vality Wallets. Webhooks Events API
 *  ## Wallet Webhook Events API The specification defines a protocol for delivering notifications about new wallet events within your organisation. The notifications are deliveried by the system as HTTP requests to the URL of webhooks you created. Handlers for such kind of queries should be implemented on the side of your server code according to the specification.  Webhook is a subscription to a specific type of event or group of events relating to different objects within your organisation. API methods described in the specification [Vality Webhook Management API](https:/github.com/valitydev/swag-wallets) are used to manage webhooks.  When within the wallet one of the events occurs (e.g. a wallet status change), the system selects a webhook matching that event type and sends an HTTP request containing a JSON message to the URL specified in the webhook. If several webhooks matching this event type were created, the event is simultaneously delivered to all URLs specified in those webhooks in an undefined order. ## Delivery strategy The system guarantees events delivery order within a specific notification subject (wallet, deposit, withdrawal, etc.). The system maintains a message queue for each notification item to keep the sequence and ensure the guaranteed delivery.  A delivery request is considered to be successful only when a response with status `200` is received. The system will wait for a successful response to the sent a request during 10 seconds. In case of a response with any other status or after expiration of the specified time which was reserved to process the notification, the system will try to re-deliver notifications until a successful response is received, or until a decision is made that it is impossible to deliver information. Delivery attempts will be made at the following time intervals between requests:    - 30 seconds,   - 5 minutes,   - 15 minutes,   - 1 hour.   - every hour within 24 hours  If the last attempt of notification delivery fails, all the events that have been accumulated in this wallet queue are discarded. ## Received messages authorization The system confirms notifications authenticity by signing messages with a private key that is unique to each webhook, the paired public key of which is contained in the data of that webhook. The signature is transmitted in the HTTP header Content-Signature. Represented in various atributes the header contains the information about the algorithm used to create a signature and content of the signature in the format [URL-safe base-64](https://tools.ietf.org/html/rfc4648).  ``` Content-Signature: alg=RS256; digest=zFuf7bRH4RHwyktaqHQwmX5rn3LfSb4dKo... ```  At the moment the only one signature generation algorithm is possible to use. ### [RS256](https://tools.ietf.org/html/rfc7518#section-3.3) The signature is generated according to [RSASSA-PKCS1-v1_5](https://tools.ietf.org/html/rfc3447#section-8.2) algorithm , which itself uses result of message [SHA-256](https://tools.ietf.org/html/rfc6234) calculation.  The set of header attributes and the list of possible signature generation algorithms can be expanded later. 
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package dev.vality.swag.wallets.webhook.events.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.wallets.webhook.events.model.BankCard;
import dev.vality.swag.wallets.webhook.events.model.BankCardAllOf;
import dev.vality.swag.wallets.webhook.events.model.BankCardTokenProvider;
import dev.vality.swag.wallets.webhook.events.model.CryptoWallet;
import dev.vality.swag.wallets.webhook.events.model.DestinationResource;
import dev.vality.swag.wallets.webhook.events.model.DigitalWallet;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Bank card details
 */
@ApiModel(description = "Bank card details")
@JsonPropertyOrder({
  BankCard.JSON_PROPERTY_CARD_NUMBER_MASK,
  BankCard.JSON_PROPERTY_BIN,
  BankCard.JSON_PROPERTY_LAST_DIGITS,
  BankCard.JSON_PROPERTY_PAYMENT_SYSTEM,
  BankCard.JSON_PROPERTY_TOKEN_PROVIDER
})
@JsonTypeName("BankCard")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-16T04:28:01.671984653Z[Etc/UTC]")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "type", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = BankCard.class, name = "BankCard"),
  @JsonSubTypes.Type(value = CryptoWallet.class, name = "CryptoWallet"),
  @JsonSubTypes.Type(value = DigitalWallet.class, name = "DigitalWallet"),
})

public class BankCard extends DestinationResource {
  public static final String JSON_PROPERTY_CARD_NUMBER_MASK = "cardNumberMask";
  private String cardNumberMask;

  public static final String JSON_PROPERTY_BIN = "bin";
  private String bin;

  public static final String JSON_PROPERTY_LAST_DIGITS = "lastDigits";
  private String lastDigits;

  public static final String JSON_PROPERTY_PAYMENT_SYSTEM = "paymentSystem";
  private String paymentSystem;

  public static final String JSON_PROPERTY_TOKEN_PROVIDER = "tokenProvider";
  private BankCardTokenProvider tokenProvider;

  public BankCard() { 
  }

  public BankCard cardNumberMask(String cardNumberMask) {
    
    this.cardNumberMask = cardNumberMask;
    return this;
  }

   /**
   * Masked card number
   * @return cardNumberMask
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Masked card number")
  @JsonProperty(JSON_PROPERTY_CARD_NUMBER_MASK)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCardNumberMask() {
    return cardNumberMask;
  }


  @JsonProperty(JSON_PROPERTY_CARD_NUMBER_MASK)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCardNumberMask(String cardNumberMask) {
    this.cardNumberMask = cardNumberMask;
  }


  public BankCard bin(String bin) {
    
    this.bin = bin;
    return this;
  }

   /**
   * Card issuing bank BIN
   * @return bin
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Card issuing bank BIN")
  @JsonProperty(JSON_PROPERTY_BIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBin() {
    return bin;
  }


  @JsonProperty(JSON_PROPERTY_BIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBin(String bin) {
    this.bin = bin;
  }


  public BankCard lastDigits(String lastDigits) {
    
    this.lastDigits = lastDigits;
    return this;
  }

   /**
   * Card last digits
   * @return lastDigits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Card last digits")
  @JsonProperty(JSON_PROPERTY_LAST_DIGITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLastDigits() {
    return lastDigits;
  }


  @JsonProperty(JSON_PROPERTY_LAST_DIGITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastDigits(String lastDigits) {
    this.lastDigits = lastDigits;
  }


  public BankCard paymentSystem(String paymentSystem) {
    
    this.paymentSystem = paymentSystem;
    return this;
  }

   /**
   * Payment system
   * @return paymentSystem
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Payment system")
  @JsonProperty(JSON_PROPERTY_PAYMENT_SYSTEM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPaymentSystem() {
    return paymentSystem;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_SYSTEM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPaymentSystem(String paymentSystem) {
    this.paymentSystem = paymentSystem;
  }


  public BankCard tokenProvider(BankCardTokenProvider tokenProvider) {
    
    this.tokenProvider = tokenProvider;
    return this;
  }

   /**
   * Get tokenProvider
   * @return tokenProvider
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOKEN_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BankCardTokenProvider getTokenProvider() {
    return tokenProvider;
  }


  @JsonProperty(JSON_PROPERTY_TOKEN_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTokenProvider(BankCardTokenProvider tokenProvider) {
    this.tokenProvider = tokenProvider;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BankCard bankCard = (BankCard) o;
    return Objects.equals(this.cardNumberMask, bankCard.cardNumberMask) &&
        Objects.equals(this.bin, bankCard.bin) &&
        Objects.equals(this.lastDigits, bankCard.lastDigits) &&
        Objects.equals(this.paymentSystem, bankCard.paymentSystem) &&
        Objects.equals(this.tokenProvider, bankCard.tokenProvider) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cardNumberMask, bin, lastDigits, paymentSystem, tokenProvider, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BankCard {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    cardNumberMask: ").append(toIndentedString(cardNumberMask)).append("\n");
    sb.append("    bin: ").append(toIndentedString(bin)).append("\n");
    sb.append("    lastDigits: ").append(toIndentedString(lastDigits)).append("\n");
    sb.append("    paymentSystem: ").append(toIndentedString(paymentSystem)).append("\n");
    sb.append("    tokenProvider: ").append(toIndentedString(tokenProvider)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

