/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag.wallets.webhook.events.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.vality.swag.wallets.webhook.events.model.BankCardTokenProvider;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

public class BankCardAllOf {
    @JsonProperty(value="cardNumberMask")
    private String cardNumberMask;
    @JsonProperty(value="bin")
    private String bin;
    @JsonProperty(value="lastDigits")
    private String lastDigits;
    @JsonProperty(value="paymentSystem")
    private String paymentSystem;
    @JsonProperty(value="tokenProvider")
    private BankCardTokenProvider tokenProvider;

    public BankCardAllOf cardNumberMask(String cardNumberMask) {
        this.cardNumberMask = cardNumberMask;
        return this;
    }

    @NotNull
    @Pattern(regexp="^\\d{6,8}\\*+\\d{2,4}$")
    @Schema(name="cardNumberMask", description="Masked card number", required=true)
    public @NotNull @Pattern(regexp="^\\d{6,8}\\*+\\d{2,4}$") String getCardNumberMask() {
        return this.cardNumberMask;
    }

    public void setCardNumberMask(String cardNumberMask) {
        this.cardNumberMask = cardNumberMask;
    }

    public BankCardAllOf bin(String bin) {
        this.bin = bin;
        return this;
    }

    @Pattern(regexp="^\\d{6,8}$")
    @Schema(name="bin", description="Card issuing bank BIN", required=false)
    public @Pattern(regexp="^\\d{6,8}$") String getBin() {
        return this.bin;
    }

    public void setBin(String bin) {
        this.bin = bin;
    }

    public BankCardAllOf lastDigits(String lastDigits) {
        this.lastDigits = lastDigits;
        return this;
    }

    @Pattern(regexp="^\\d{2,4}$")
    @Schema(name="lastDigits", description="Card last digits", required=false)
    public @Pattern(regexp="^\\d{2,4}$") String getLastDigits() {
        return this.lastDigits;
    }

    public void setLastDigits(String lastDigits) {
        this.lastDigits = lastDigits;
    }

    public BankCardAllOf paymentSystem(String paymentSystem) {
        this.paymentSystem = paymentSystem;
        return this;
    }

    @NotNull
    @Schema(name="paymentSystem", description="Payment system", required=true)
    public String getPaymentSystem() {
        return this.paymentSystem;
    }

    public void setPaymentSystem(String paymentSystem) {
        this.paymentSystem = paymentSystem;
    }

    public BankCardAllOf tokenProvider(BankCardTokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
        return this;
    }

    @Valid
    @Schema(name="tokenProvider", required=false)
    public BankCardTokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    public void setTokenProvider(BankCardTokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankCardAllOf bankCardAllOf = (BankCardAllOf)o;
        return Objects.equals(this.cardNumberMask, bankCardAllOf.cardNumberMask) && Objects.equals(this.bin, bankCardAllOf.bin) && Objects.equals(this.lastDigits, bankCardAllOf.lastDigits) && Objects.equals(this.paymentSystem, bankCardAllOf.paymentSystem) && Objects.equals((Object)this.tokenProvider, (Object)bankCardAllOf.tokenProvider);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cardNumberMask, this.bin, this.lastDigits, this.paymentSystem, this.tokenProvider});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankCardAllOf {\n");
        sb.append("    cardNumberMask: ").append(this.toIndentedString(this.cardNumberMask)).append("\n");
        sb.append("    bin: ").append(this.toIndentedString(this.bin)).append("\n");
        sb.append("    lastDigits: ").append(this.toIndentedString(this.lastDigits)).append("\n");
        sb.append("    paymentSystem: ").append(this.toIndentedString(this.paymentSystem)).append("\n");
        sb.append("    tokenProvider: ").append(this.toIndentedString((Object)this.tokenProvider)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

