package dev.vality.swag.wallets.webhook.events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.wallets.webhook.events.model.DestinationAuthorizedAllOf;
import dev.vality.swag.wallets.webhook.events.model.Event;
import java.time.OffsetDateTime;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Changing the status of the destination receiver to authorized
 */

@Schema(name = "DestinationAuthorized", description = "Changing the status of the destination receiver to authorized")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-10-13T07:03:52.426980317Z[Etc/UTC]")
public class DestinationAuthorized extends Event  {

  @JsonProperty("destinationID")
  private String destinationID;

  @JsonProperty("externalID")
  private String externalID;

  public DestinationAuthorized destinationID(String destinationID) {
    this.destinationID = destinationID;
    return this;
  }

  /**
   * Destination identifier
   * @return destinationID
  */
  @NotNull 
  @Schema(name = "destinationID", example = "10ASF74D98", description = "Destination identifier", required = true)
  public String getDestinationID() {
    return destinationID;
  }

  public void setDestinationID(String destinationID) {
    this.destinationID = destinationID;
  }

  public DestinationAuthorized externalID(String externalID) {
    this.externalID = externalID;
    return this;
  }

  /**
   * The unique identifier of the content on your side.  When specified, will be used to ensure idempotent processing of the operation. 
   * @return externalID
  */
  
  @Schema(name = "externalID", example = "10036274", description = "The unique identifier of the content on your side.  When specified, will be used to ensure idempotent processing of the operation. ", required = false)
  public String getExternalID() {
    return externalID;
  }

  public void setExternalID(String externalID) {
    this.externalID = externalID;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DestinationAuthorized destinationAuthorized = (DestinationAuthorized) o;
    return Objects.equals(this.destinationID, destinationAuthorized.destinationID) &&
        Objects.equals(this.externalID, destinationAuthorized.externalID) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(destinationID, externalID, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DestinationAuthorized {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    destinationID: ").append(toIndentedString(destinationID)).append("\n");
    sb.append("    externalID: ").append(toIndentedString(externalID)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

