package dev.vality.swag.wallets.webhook.events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.swag.wallets.webhook.events.model.DestinationResource;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Destination data
 */

@Schema(name = "Destination", description = "Destination data")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-10-13T07:03:52.426980317Z[Etc/UTC]")
public class Destination   {

  @JsonProperty("id")
  private String id;

  @JsonProperty("name")
  private String name;

  @JsonProperty("identity")
  private String identity;

  @JsonProperty("currency")
  private String currency;

  @JsonProperty("resource")
  private DestinationResource resource;

  @JsonProperty("metadata")
  private Object metadata;

  @JsonProperty("externalID")
  private String externalID;

  public Destination id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Destination identifier
   * @return id
  */
  
  @Schema(name = "id", example = "10ASF74D98", description = "Destination identifier", required = false)
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Destination name(String name) {
    this.name = name;
    return this;
  }

  /**
   * A human-readable name for the receiver by which it is easily recognizable 
   * @return name
  */
  @NotNull 
  @Schema(name = "name", example = "Squarey plastic thingy", description = "A human-readable name for the receiver by which it is easily recognizable ", required = true)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Destination identity(String identity) {
    this.identity = identity;
    return this;
  }

  /**
   * Identifier of wallet owner
   * @return identity
  */
  @NotNull 
  @Schema(name = "identity", example = "tZ0jUmlsV0", description = "Identifier of wallet owner", required = true)
  public String getIdentity() {
    return identity;
  }

  public void setIdentity(String identity) {
    this.identity = identity;
  }

  public Destination currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Currency, character code according to [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). 
   * @return currency
  */
  @NotNull @Pattern(regexp = "^[A-Z]{3}$") 
  @Schema(name = "currency", example = "RUB", description = "Currency, character code according to [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). ", required = true)
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public Destination resource(DestinationResource resource) {
    this.resource = resource;
    return this;
  }

  /**
   * Get resource
   * @return resource
  */
  @NotNull @Valid 
  @Schema(name = "resource", required = true)
  public DestinationResource getResource() {
    return resource;
  }

  public void setResource(DestinationResource resource) {
    this.resource = resource;
  }

  public Destination metadata(Object metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * An arbitrary, client-specific API and non-transparent set of data associated with given receiver 
   * @return metadata
  */
  
  @Schema(name = "metadata", example = "{\"color_hint\":\"olive-green\"}", description = "An arbitrary, client-specific API and non-transparent set of data associated with given receiver ", required = false)
  public Object getMetadata() {
    return metadata;
  }

  public void setMetadata(Object metadata) {
    this.metadata = metadata;
  }

  public Destination externalID(String externalID) {
    this.externalID = externalID;
    return this;
  }

  /**
   * The unique identifier of the content on your side.  When specified, will be used to ensure idempotent processing of the operation. 
   * @return externalID
  */
  
  @Schema(name = "externalID", example = "10036274", description = "The unique identifier of the content on your side.  When specified, will be used to ensure idempotent processing of the operation. ", required = false)
  public String getExternalID() {
    return externalID;
  }

  public void setExternalID(String externalID) {
    this.externalID = externalID;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Destination destination = (Destination) o;
    return Objects.equals(this.id, destination.id) &&
        Objects.equals(this.name, destination.name) &&
        Objects.equals(this.identity, destination.identity) &&
        Objects.equals(this.currency, destination.currency) &&
        Objects.equals(this.resource, destination.resource) &&
        Objects.equals(this.metadata, destination.metadata) &&
        Objects.equals(this.externalID, destination.externalID);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, identity, currency, resource, metadata, externalID);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Destination {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    identity: ").append(toIndentedString(identity)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    resource: ").append(toIndentedString(resource)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    externalID: ").append(toIndentedString(externalID)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

