/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag.wallets.webhook.events.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@Schema(name="WithdrawalBody", description="Amount of funds to be withdrawn ")
public class WithdrawalBody {
    @JsonProperty(value="amount")
    private Long amount;
    @JsonProperty(value="currency")
    private String currency;

    public WithdrawalBody amount(Long amount) {
        this.amount = amount;
        return this;
    }

    @NotNull
    @Schema(name="amount", example="1430000", description="The amount of money in minor units, for example, in cents ", required=true)
    public Long getAmount() {
        return this.amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public WithdrawalBody currency(String currency) {
        this.currency = currency;
        return this;
    }

    @NotNull
    @Pattern(regexp="^[A-Z]{3}$")
    @Schema(name="currency", example="RUB", description="Currency, character code according to [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). ", required=true)
    public @NotNull @Pattern(regexp="^[A-Z]{3}$") String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WithdrawalBody withdrawalBody = (WithdrawalBody)o;
        return Objects.equals(this.amount, withdrawalBody.amount) && Objects.equals(this.currency, withdrawalBody.currency);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.currency);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WithdrawalBody {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

