/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag.wallets.webhook.events.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.vality.swag.wallets.webhook.events.model.DestinationResource;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Schema(name="DigitalWallet", description="Cryptocurrency wallet details")
public class DigitalWallet
extends DestinationResource {
    @JsonProperty(value="digitalWalletId")
    private String digitalWalletId;
    @JsonProperty(value="digitalWalletProvider")
    private String digitalWalletProvider;

    public DigitalWallet digitalWalletId(String digitalWalletId) {
        this.digitalWalletId = digitalWalletId;
        return this;
    }

    @NotNull
    @Size(min=16, max=256)
    @Schema(name="digitalWalletId", example="zu3TcwGI71Bpaaw2XkLWZXlhMdn4zpVzMQ", description="E-wallet identifier", required=true)
    public @NotNull @Size(min=16, max=256) String getDigitalWalletId() {
        return this.digitalWalletId;
    }

    public void setDigitalWalletId(String digitalWalletId) {
        this.digitalWalletId = digitalWalletId;
    }

    public DigitalWallet digitalWalletProvider(String digitalWalletProvider) {
        this.digitalWalletProvider = digitalWalletProvider;
        return this;
    }

    @NotNull
    @Schema(name="digitalWalletProvider", example="Paypal", description="Electronic assets service provider", required=true)
    public String getDigitalWalletProvider() {
        return this.digitalWalletProvider;
    }

    public void setDigitalWalletProvider(String digitalWalletProvider) {
        this.digitalWalletProvider = digitalWalletProvider;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DigitalWallet digitalWallet = (DigitalWallet)o;
        return Objects.equals(this.digitalWalletId, digitalWallet.digitalWalletId) && Objects.equals(this.digitalWalletProvider, digitalWallet.digitalWalletProvider) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.digitalWalletId, this.digitalWalletProvider, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DigitalWallet {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    digitalWalletId: ").append(this.toIndentedString(this.digitalWalletId)).append("\n");
        sb.append("    digitalWalletProvider: ").append(this.toIndentedString(this.digitalWalletProvider)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

