/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag.wallets.webhook.events.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import dev.vality.swag.wallets.webhook.events.model.DestinationResource;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Destination data")
@JsonPropertyOrder(value={"id", "name", "identity", "currency", "resource", "metadata", "externalID"})
@JsonTypeName(value="Destination")
public class Destination {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_IDENTITY = "identity";
    private String identity;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;
    public static final String JSON_PROPERTY_RESOURCE = "resource";
    private DestinationResource resource;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Object metadata;
    public static final String JSON_PROPERTY_EXTERNAL_I_D = "externalID";
    private String externalID;

    public Destination id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10ASF74D98", value="Destination identifier")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public Destination name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Squarey plastic thingy", required=true, value="A human-readable name for the receiver by which it is easily recognizable ")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public Destination identity(String identity) {
        this.identity = identity;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="tZ0jUmlsV0", required=true, value="Identifier of wallet owner")
    @JsonProperty(value="identity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIdentity() {
        return this.identity;
    }

    @JsonProperty(value="identity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public Destination currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="RUB", required=true, value="Currency, character code according to [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). ")
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Destination resource(DestinationResource resource) {
        this.resource = resource;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="resource")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DestinationResource getResource() {
        return this.resource;
    }

    @JsonProperty(value="resource")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setResource(DestinationResource resource) {
        this.resource = resource;
    }

    public Destination metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"color_hint\":\"olive-green\"}", value="An arbitrary, client-specific API and non-transparent set of data associated with given receiver ")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public Destination externalID(String externalID) {
        this.externalID = externalID;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10036274", value="The unique identifier of the content on your side.  When specified, will be used to ensure idempotent processing of the operation. ")
    @JsonProperty(value="externalID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalID() {
        return this.externalID;
    }

    @JsonProperty(value="externalID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalID(String externalID) {
        this.externalID = externalID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Destination destination = (Destination)o;
        return Objects.equals(this.id, destination.id) && Objects.equals(this.name, destination.name) && Objects.equals(this.identity, destination.identity) && Objects.equals(this.currency, destination.currency) && Objects.equals(this.resource, destination.resource) && Objects.equals(this.metadata, destination.metadata) && Objects.equals(this.externalID, destination.externalID);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.identity, this.currency, this.resource, this.metadata, this.externalID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Destination {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    identity: ").append(this.toIndentedString(this.identity)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    externalID: ").append(this.toIndentedString(this.externalID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

