/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag.wallets.webhook.events.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import dev.vality.swag.wallets.webhook.events.model.BankCardTokenProvider;
import dev.vality.swag.wallets.webhook.events.model.CryptoWallet;
import dev.vality.swag.wallets.webhook.events.model.DestinationResource;
import dev.vality.swag.wallets.webhook.events.model.DigitalWallet;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Bank card details")
@JsonPropertyOrder(value={"cardNumberMask", "bin", "lastDigits", "paymentSystem", "tokenProvider"})
@JsonTypeName(value="BankCard")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=BankCard.class, name="BankCard"), @JsonSubTypes.Type(value=CryptoWallet.class, name="CryptoWallet"), @JsonSubTypes.Type(value=DigitalWallet.class, name="DigitalWallet")})
public class BankCard
extends DestinationResource {
    public static final String JSON_PROPERTY_CARD_NUMBER_MASK = "cardNumberMask";
    private String cardNumberMask;
    public static final String JSON_PROPERTY_BIN = "bin";
    private String bin;
    public static final String JSON_PROPERTY_LAST_DIGITS = "lastDigits";
    private String lastDigits;
    public static final String JSON_PROPERTY_PAYMENT_SYSTEM = "paymentSystem";
    private String paymentSystem;
    public static final String JSON_PROPERTY_TOKEN_PROVIDER = "tokenProvider";
    private BankCardTokenProvider tokenProvider;

    public BankCard cardNumberMask(String cardNumberMask) {
        this.cardNumberMask = cardNumberMask;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Masked card number")
    @JsonProperty(value="cardNumberMask")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCardNumberMask() {
        return this.cardNumberMask;
    }

    @JsonProperty(value="cardNumberMask")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCardNumberMask(String cardNumberMask) {
        this.cardNumberMask = cardNumberMask;
    }

    public BankCard bin(String bin) {
        this.bin = bin;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Card issuing bank BIN")
    @JsonProperty(value="bin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBin() {
        return this.bin;
    }

    @JsonProperty(value="bin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBin(String bin) {
        this.bin = bin;
    }

    public BankCard lastDigits(String lastDigits) {
        this.lastDigits = lastDigits;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Card last digits")
    @JsonProperty(value="lastDigits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastDigits() {
        return this.lastDigits;
    }

    @JsonProperty(value="lastDigits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastDigits(String lastDigits) {
        this.lastDigits = lastDigits;
    }

    public BankCard paymentSystem(String paymentSystem) {
        this.paymentSystem = paymentSystem;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Payment system")
    @JsonProperty(value="paymentSystem")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPaymentSystem() {
        return this.paymentSystem;
    }

    @JsonProperty(value="paymentSystem")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPaymentSystem(String paymentSystem) {
        this.paymentSystem = paymentSystem;
    }

    public BankCard tokenProvider(BankCardTokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="tokenProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BankCardTokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    @JsonProperty(value="tokenProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokenProvider(BankCardTokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankCard bankCard = (BankCard)o;
        return Objects.equals(this.cardNumberMask, bankCard.cardNumberMask) && Objects.equals(this.bin, bankCard.bin) && Objects.equals(this.lastDigits, bankCard.lastDigits) && Objects.equals(this.paymentSystem, bankCard.paymentSystem) && Objects.equals((Object)this.tokenProvider, (Object)bankCard.tokenProvider) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.cardNumberMask, this.bin, this.lastDigits, this.paymentSystem, this.tokenProvider, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankCard {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    cardNumberMask: ").append(this.toIndentedString(this.cardNumberMask)).append("\n");
        sb.append("    bin: ").append(this.toIndentedString(this.bin)).append("\n");
        sb.append("    lastDigits: ").append(this.toIndentedString(this.lastDigits)).append("\n");
        sb.append("    paymentSystem: ").append(this.toIndentedString(this.paymentSystem)).append("\n");
        sb.append("    tokenProvider: ").append(this.toIndentedString((Object)this.tokenProvider)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

