/*
 * Vality Wallets. Webhooks Events API
 *  ## Wallet Webhook Events API The specification defines a protocol for delivering notifications about new wallet events within your organisation. The notifications are deliveried by the system as HTTP requests to the URL of webhooks you created. Handlers for such kind of queries should be implemented on the side of your server code according to the specification.  Webhook is a subscription to a specific type of event or group of events relating to different objects within your organisation. API methods described in the specification [Vality Webhook Management API](https:/github.com/valitydev/swag-wallets) are used to manage webhooks.  When within the wallet one of the events occurs (e.g. a wallet status change), the system selects a webhook matching that event type and sends an HTTP request containing a JSON message to the URL specified in the webhook. If several webhooks matching this event type were created, the event is simultaneously delivered to all URLs specified in those webhooks in an undefined order. ## Delivery strategy The system guarantees events delivery order within a specific notification subject (wallet, deposit, withdrawal, etc.). The system maintains a message queue for each notification item to keep the sequence and ensure the guaranteed delivery.  A delivery request is considered to be successful only when a response with status `200` is received. The system will wait for a successful response to the sent a request during 10 seconds. In case of a response with any other status or after expiration of the specified time which was reserved to process the notification, the system will try to re-deliver notifications until a successful response is received, or until a decision is made that it is impossible to deliver information. Delivery attempts will be made at the following time intervals between requests:    - 30 seconds,   - 5 minutes,   - 15 minutes,   - 1 hour.   - every hour within 24 hours  If the last attempt of notification delivery fails, all the events that have been accumulated in this wallet queue are discarded. ## Received messages authorization The system confirms notifications authenticity by signing messages with a private key that is unique to each webhook, the paired public key of which is contained in the data of that webhook. The signature is transmitted in the HTTP header Content-Signature. Represented in various atributes the header contains the information about the algorithm used to create a signature and content of the signature in the format [URL-safe base-64](https://tools.ietf.org/html/rfc4648).  ``` Content-Signature: alg=RS256; digest=zFuf7bRH4RHwyktaqHQwmX5rn3LfSb4dKo... ```  At the moment the only one signature generation algorithm is possible to use. ### [RS256](https://tools.ietf.org/html/rfc7518#section-3.3) The signature is generated according to [RSASSA-PKCS1-v1_5](https://tools.ietf.org/html/rfc3447#section-8.2) algorithm , which itself uses result of message [SHA-256](https://tools.ietf.org/html/rfc6234) calculation.  The set of header attributes and the list of possible signature generation algorithms can be expanded later. 
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package dev.vality.swag.wallets.webhook.events.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.wallets.webhook.events.model.WithdrawalBody;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Funds withdrawal data
 */
@ApiModel(description = "Funds withdrawal data")
@JsonPropertyOrder({
  Withdrawal.JSON_PROPERTY_ID,
  Withdrawal.JSON_PROPERTY_CREATED_AT,
  Withdrawal.JSON_PROPERTY_DESTINATION,
  Withdrawal.JSON_PROPERTY_BODY,
  Withdrawal.JSON_PROPERTY_METADATA,
  Withdrawal.JSON_PROPERTY_WALLET,
  Withdrawal.JSON_PROPERTY_EXTERNAL_I_D
})
@JsonTypeName("Withdrawal")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-09-21T13:44:22.979521869Z[Etc/UTC]")
public class Withdrawal {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_DESTINATION = "destination";
  private String destination;

  public static final String JSON_PROPERTY_BODY = "body";
  private WithdrawalBody body;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private JsonNullable<Object> metadata = JsonNullable.<Object>of(null);

  public static final String JSON_PROPERTY_WALLET = "wallet";
  private String wallet;

  public static final String JSON_PROPERTY_EXTERNAL_I_D = "externalID";
  private String externalID;

  public Withdrawal() { 
  }

  public Withdrawal id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Identifier of funds withdrawal
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "tZ0jUmlsV0", value = "Identifier of funds withdrawal")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public Withdrawal createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Date and time the withdrawal started
   * @return createdAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Date and time the withdrawal started")
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public Withdrawal destination(String destination) {
    
    this.destination = destination;
    return this;
  }

   /**
   * Destination identifier
   * @return destination
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "10ASF74D98", required = true, value = "Destination identifier")
  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDestination() {
    return destination;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDestination(String destination) {
    this.destination = destination;
  }


  public Withdrawal body(WithdrawalBody body) {
    
    this.body = body;
    return this;
  }

   /**
   * Get body
   * @return body
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public WithdrawalBody getBody() {
    return body;
  }


  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBody(WithdrawalBody body) {
    this.body = body;
  }


  public Withdrawal metadata(Object metadata) {
    this.metadata = JsonNullable.<Object>of(metadata);
    
    return this;
  }

   /**
   * A custom client-specific API and a data set that is not transparent to the system, associated with this withdrawal 
   * @return metadata
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A custom client-specific API and a data set that is not transparent to the system, associated with this withdrawal ")
  @JsonIgnore

  public Object getMetadata() {
        return metadata.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Object> getMetadata_JsonNullable() {
    return metadata;
  }
  
  @JsonProperty(JSON_PROPERTY_METADATA)
  public void setMetadata_JsonNullable(JsonNullable<Object> metadata) {
    this.metadata = metadata;
  }

  public void setMetadata(Object metadata) {
    this.metadata = JsonNullable.<Object>of(metadata);
  }


  public Withdrawal wallet(String wallet) {
    
    this.wallet = wallet;
    return this;
  }

   /**
   * Identifier of the wallet
   * @return wallet
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "10068321", required = true, value = "Identifier of the wallet")
  @JsonProperty(JSON_PROPERTY_WALLET)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getWallet() {
    return wallet;
  }


  @JsonProperty(JSON_PROPERTY_WALLET)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setWallet(String wallet) {
    this.wallet = wallet;
  }


  public Withdrawal externalID(String externalID) {
    
    this.externalID = externalID;
    return this;
  }

   /**
   * The unique identifier of the content on your side.  When specified, will be used to ensure idempotent processing of the operation. 
   * @return externalID
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10036274", value = "The unique identifier of the content on your side.  When specified, will be used to ensure idempotent processing of the operation. ")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalID() {
    return externalID;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalID(String externalID) {
    this.externalID = externalID;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Withdrawal withdrawal = (Withdrawal) o;
    return Objects.equals(this.id, withdrawal.id) &&
        Objects.equals(this.createdAt, withdrawal.createdAt) &&
        Objects.equals(this.destination, withdrawal.destination) &&
        Objects.equals(this.body, withdrawal.body) &&
        equalsNullable(this.metadata, withdrawal.metadata) &&
        Objects.equals(this.wallet, withdrawal.wallet) &&
        Objects.equals(this.externalID, withdrawal.externalID);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdAt, destination, body, hashCodeNullable(metadata), wallet, externalID);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Withdrawal {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    destination: ").append(toIndentedString(destination)).append("\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    wallet: ").append(toIndentedString(wallet)).append("\n");
    sb.append("    externalID: ").append(toIndentedString(externalID)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

