/*
 * Vality Wallets. Webhooks Events API
 *  ## Wallet Webhook Events API The specification defines a protocol for delivering notifications about new wallet events within your organisation. The notifications are deliveried by the system as HTTP requests to the URL of webhooks you created. Handlers for such kind of queries should be implemented on the side of your server code according to the specification.  Webhook is a subscription to a specific type of event or group of events relating to different objects within your organisation. API methods described in the specification [Vality Webhook Management API](https:/github.com/valitydev/swag-wallets) are used to manage webhooks.  When within the wallet one of the events occurs (e.g. a wallet status change), the system selects a webhook matching that event type and sends an HTTP request containing a JSON message to the URL specified in the webhook. If several webhooks matching this event type were created, the event is simultaneously delivered to all URLs specified in those webhooks in an undefined order. ## Delivery strategy The system guarantees events delivery order within a specific notification subject (wallet, deposit, withdrawal, etc.). The system maintains a message queue for each notification item to keep the sequence and ensure the guaranteed delivery.  A delivery request is considered to be successful only when a response with status `200` is received. The system will wait for a successful response to the sent a request during 10 seconds. In case of a response with any other status or after expiration of the specified time which was reserved to process the notification, the system will try to re-deliver notifications until a successful response is received, or until a decision is made that it is impossible to deliver information. Delivery attempts will be made at the following time intervals between requests:    - 30 seconds,   - 5 minutes,   - 15 minutes,   - 1 hour.   - every hour within 24 hours  If the last attempt of notification delivery fails, all the events that have been accumulated in this wallet queue are discarded. ## Received messages authorization The system confirms notifications authenticity by signing messages with a private key that is unique to each webhook, the paired public key of which is contained in the data of that webhook. The signature is transmitted in the HTTP header Content-Signature. Represented in various atributes the header contains the information about the algorithm used to create a signature and content of the signature in the format [URL-safe base-64](https://tools.ietf.org/html/rfc4648).  ``` Content-Signature: alg=RS256; digest=zFuf7bRH4RHwyktaqHQwmX5rn3LfSb4dKo... ```  At the moment the only one signature generation algorithm is possible to use. ### [RS256](https://tools.ietf.org/html/rfc7518#section-3.3) The signature is generated according to [RSASSA-PKCS1-v1_5](https://tools.ietf.org/html/rfc3447#section-8.2) algorithm , which itself uses result of message [SHA-256](https://tools.ietf.org/html/rfc6234) calculation.  The set of header attributes and the list of possible signature generation algorithms can be expanded later. 
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package dev.vality.swag.wallets.webhook.events.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.wallets.webhook.events.model.DestinationResource;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Destination data
 */
@ApiModel(description = "Destination data")
@JsonPropertyOrder({
  Destination.JSON_PROPERTY_ID,
  Destination.JSON_PROPERTY_NAME,
  Destination.JSON_PROPERTY_IDENTITY,
  Destination.JSON_PROPERTY_CURRENCY,
  Destination.JSON_PROPERTY_RESOURCE,
  Destination.JSON_PROPERTY_METADATA,
  Destination.JSON_PROPERTY_EXTERNAL_I_D
})
@JsonTypeName("Destination")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-09-21T13:44:22.979521869Z[Etc/UTC]")
public class Destination {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_IDENTITY = "identity";
  private String identity;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_RESOURCE = "resource";
  private DestinationResource resource;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Object metadata;

  public static final String JSON_PROPERTY_EXTERNAL_I_D = "externalID";
  private String externalID;

  public Destination() { 
  }

  public Destination id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Destination identifier
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10ASF74D98", value = "Destination identifier")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public Destination name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * A human-readable name for the receiver by which it is easily recognizable 
   * @return name
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "Squarey plastic thingy", required = true, value = "A human-readable name for the receiver by which it is easily recognizable ")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public Destination identity(String identity) {
    
    this.identity = identity;
    return this;
  }

   /**
   * Identifier of wallet owner
   * @return identity
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "tZ0jUmlsV0", required = true, value = "Identifier of wallet owner")
  @JsonProperty(JSON_PROPERTY_IDENTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIdentity() {
    return identity;
  }


  @JsonProperty(JSON_PROPERTY_IDENTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentity(String identity) {
    this.identity = identity;
  }


  public Destination currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Currency, character code according to [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). 
   * @return currency
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "RUB", required = true, value = "Currency, character code according to [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). ")
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public Destination resource(DestinationResource resource) {
    
    this.resource = resource;
    return this;
  }

   /**
   * Get resource
   * @return resource
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_RESOURCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public DestinationResource getResource() {
    return resource;
  }


  @JsonProperty(JSON_PROPERTY_RESOURCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setResource(DestinationResource resource) {
    this.resource = resource;
  }


  public Destination metadata(Object metadata) {
    
    this.metadata = metadata;
    return this;
  }

   /**
   * An arbitrary, client-specific API and non-transparent set of data associated with given receiver 
   * @return metadata
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "{\"color_hint\":\"olive-green\"}", value = "An arbitrary, client-specific API and non-transparent set of data associated with given receiver ")
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Object metadata) {
    this.metadata = metadata;
  }


  public Destination externalID(String externalID) {
    
    this.externalID = externalID;
    return this;
  }

   /**
   * The unique identifier of the content on your side.  When specified, will be used to ensure idempotent processing of the operation. 
   * @return externalID
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10036274", value = "The unique identifier of the content on your side.  When specified, will be used to ensure idempotent processing of the operation. ")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalID() {
    return externalID;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalID(String externalID) {
    this.externalID = externalID;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Destination destination = (Destination) o;
    return Objects.equals(this.id, destination.id) &&
        Objects.equals(this.name, destination.name) &&
        Objects.equals(this.identity, destination.identity) &&
        Objects.equals(this.currency, destination.currency) &&
        Objects.equals(this.resource, destination.resource) &&
        Objects.equals(this.metadata, destination.metadata) &&
        Objects.equals(this.externalID, destination.externalID);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, identity, currency, resource, metadata, externalID);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Destination {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    identity: ").append(toIndentedString(identity)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    resource: ").append(toIndentedString(resource)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    externalID: ").append(toIndentedString(externalID)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

