package dev.vality.swag.wallets.webhook.events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.wallets.webhook.events.model.Event;
import dev.vality.swag.wallets.webhook.events.model.WithdrawalSucceededAllOf;
import java.time.OffsetDateTime;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Событие о неуспешном осуществлении вывода средств
 */

@Schema(name = "WithdrawalFailed", description = "Событие о неуспешном осуществлении вывода средств")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-08-03T05:09:11.019593575Z[Etc/UTC]")
public class WithdrawalFailed extends Event  {

  @JsonProperty("withdrawalID")
  private String withdrawalID;

  @JsonProperty("externalID")
  private String externalID;

  public WithdrawalFailed withdrawalID(String withdrawalID) {
    this.withdrawalID = withdrawalID;
    return this;
  }

  /**
   * Идентификатор вывода денежных средств
   * @return withdrawalID
  */
  @NotNull 
  @Schema(name = "withdrawalID", example = "tZ0jUmlsV0", description = "Идентификатор вывода денежных средств", required = true)
  public String getWithdrawalID() {
    return withdrawalID;
  }

  public void setWithdrawalID(String withdrawalID) {
    this.withdrawalID = withdrawalID;
  }

  public WithdrawalFailed externalID(String externalID) {
    this.externalID = externalID;
    return this;
  }

  /**
   * Уникальный идентификатор сущности на вашей стороне.  При указании будет использован для того, чтобы гарантировать идемпотентную обработку операции. 
   * @return externalID
  */
  
  @Schema(name = "externalID", example = "10036274", description = "Уникальный идентификатор сущности на вашей стороне.  При указании будет использован для того, чтобы гарантировать идемпотентную обработку операции. ", required = false)
  public String getExternalID() {
    return externalID;
  }

  public void setExternalID(String externalID) {
    this.externalID = externalID;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WithdrawalFailed withdrawalFailed = (WithdrawalFailed) o;
    return Objects.equals(this.withdrawalID, withdrawalFailed.withdrawalID) &&
        Objects.equals(this.externalID, withdrawalFailed.externalID) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(withdrawalID, externalID, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WithdrawalFailed {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    withdrawalID: ").append(toIndentedString(withdrawalID)).append("\n");
    sb.append("    externalID: ").append(toIndentedString(externalID)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

