package dev.vality.swag.wallets.webhook.events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.swag.wallets.webhook.events.model.WithdrawalBody;
import java.time.OffsetDateTime;
import java.util.Arrays;
import org.openapitools.jackson.nullable.JsonNullable;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Данные вывода денежных средств
 */

@Schema(name = "Withdrawal", description = "Данные вывода денежных средств")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-07-20T13:11:57.389263087Z[Etc/UTC]")
public class Withdrawal   {

  @JsonProperty("id")
  private String id;

  @JsonProperty("createdAt")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdAt;

  @JsonProperty("destination")
  private String destination;

  @JsonProperty("body")
  private WithdrawalBody body;

  @JsonProperty("metadata")
  private JsonNullable<Object> metadata = JsonNullable.undefined();

  @JsonProperty("wallet")
  private String wallet;

  @JsonProperty("externalID")
  private String externalID;

  public Withdrawal id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Идентификатор вывода денежных средств
   * @return id
  */
  
  @Schema(name = "id", example = "tZ0jUmlsV0", description = "Идентификатор вывода денежных средств", required = false)
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Withdrawal createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Дата и время запуска вывода
   * @return createdAt
  */
  @Valid 
  @Schema(name = "createdAt", description = "Дата и время запуска вывода", required = false)
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public Withdrawal destination(String destination) {
    this.destination = destination;
    return this;
  }

  /**
   * Идентификатор места назначения денежных средств
   * @return destination
  */
  @NotNull 
  @Schema(name = "destination", example = "10ASF74D98", description = "Идентификатор места назначения денежных средств", required = true)
  public String getDestination() {
    return destination;
  }

  public void setDestination(String destination) {
    this.destination = destination;
  }

  public Withdrawal body(WithdrawalBody body) {
    this.body = body;
    return this;
  }

  /**
   * Get body
   * @return body
  */
  @NotNull @Valid 
  @Schema(name = "body", required = true)
  public WithdrawalBody getBody() {
    return body;
  }

  public void setBody(WithdrawalBody body) {
    this.body = body;
  }

  public Withdrawal metadata(Object metadata) {
    this.metadata = JsonNullable.of(metadata);
    return this;
  }

  /**
   * Произвольный, специфичный для клиента API и непрозрачный для системы набор данных, ассоциированных с данным выводом 
   * @return metadata
  */
  
  @Schema(name = "metadata", description = "Произвольный, специфичный для клиента API и непрозрачный для системы набор данных, ассоциированных с данным выводом ", required = false)
  public JsonNullable<Object> getMetadata() {
    return metadata;
  }

  public void setMetadata(JsonNullable<Object> metadata) {
    this.metadata = metadata;
  }

  public Withdrawal wallet(String wallet) {
    this.wallet = wallet;
    return this;
  }

  /**
   * Идентификатор кошелька
   * @return wallet
  */
  @NotNull 
  @Schema(name = "wallet", example = "10068321", description = "Идентификатор кошелька", required = true)
  public String getWallet() {
    return wallet;
  }

  public void setWallet(String wallet) {
    this.wallet = wallet;
  }

  public Withdrawal externalID(String externalID) {
    this.externalID = externalID;
    return this;
  }

  /**
   * Уникальный идентификатор сущности на вашей стороне.  При указании будет использован для того, чтобы гарантировать идемпотентную обработку операции. 
   * @return externalID
  */
  
  @Schema(name = "externalID", example = "10036274", description = "Уникальный идентификатор сущности на вашей стороне.  При указании будет использован для того, чтобы гарантировать идемпотентную обработку операции. ", required = false)
  public String getExternalID() {
    return externalID;
  }

  public void setExternalID(String externalID) {
    this.externalID = externalID;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Withdrawal withdrawal = (Withdrawal) o;
    return Objects.equals(this.id, withdrawal.id) &&
        Objects.equals(this.createdAt, withdrawal.createdAt) &&
        Objects.equals(this.destination, withdrawal.destination) &&
        Objects.equals(this.body, withdrawal.body) &&
        Objects.equals(this.metadata, withdrawal.metadata) &&
        Objects.equals(this.wallet, withdrawal.wallet) &&
        Objects.equals(this.externalID, withdrawal.externalID);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdAt, destination, body, metadata, wallet, externalID);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Withdrawal {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    destination: ").append(toIndentedString(destination)).append("\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    wallet: ").append(toIndentedString(wallet)).append("\n");
    sb.append("    externalID: ").append(toIndentedString(externalID)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

