package dev.vality.swag.wallets.webhook.events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.wallets.webhook.events.model.DestinationResource;
import dev.vality.swag.wallets.webhook.events.model.DigitalWalletAllOf;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Данные криптовалютного кошелька
 */

@Schema(name = "DigitalWallet", description = "Данные криптовалютного кошелька")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-07-20T13:11:57.389263087Z[Etc/UTC]")
public class DigitalWallet extends DestinationResource  {

  @JsonProperty("digitalWalletId")
  private String digitalWalletId;

  @JsonProperty("digitalWalletProvider")
  private String digitalWalletProvider;

  public DigitalWallet digitalWalletId(String digitalWalletId) {
    this.digitalWalletId = digitalWalletId;
    return this;
  }

  /**
   * Идентификатор кошелька
   * @return digitalWalletId
  */
  @NotNull @Size(min = 16, max = 256) 
  @Schema(name = "digitalWalletId", example = "zu3TcwGI71Bpaaw2XkLWZXlhMdn4zpVzMQ", description = "Идентификатор кошелька", required = true)
  public String getDigitalWalletId() {
    return digitalWalletId;
  }

  public void setDigitalWalletId(String digitalWalletId) {
    this.digitalWalletId = digitalWalletId;
  }

  public DigitalWallet digitalWalletProvider(String digitalWalletProvider) {
    this.digitalWalletProvider = digitalWalletProvider;
    return this;
  }

  /**
   * Провайдер электронных денежных средств
   * @return digitalWalletProvider
  */
  @NotNull 
  @Schema(name = "digitalWalletProvider", example = "Paypal", description = "Провайдер электронных денежных средств", required = true)
  public String getDigitalWalletProvider() {
    return digitalWalletProvider;
  }

  public void setDigitalWalletProvider(String digitalWalletProvider) {
    this.digitalWalletProvider = digitalWalletProvider;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DigitalWallet digitalWallet = (DigitalWallet) o;
    return Objects.equals(this.digitalWalletId, digitalWallet.digitalWalletId) &&
        Objects.equals(this.digitalWalletProvider, digitalWallet.digitalWalletProvider) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(digitalWalletId, digitalWalletProvider, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DigitalWallet {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    digitalWalletId: ").append(toIndentedString(digitalWalletId)).append("\n");
    sb.append("    digitalWalletProvider: ").append(toIndentedString(digitalWalletProvider)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

