/*
 * Vality Wallets. Webhooks Events API
 *  ## Wallet Webhook Events API  Данная спецификация определяет протокол доставки оповещений о возникновении новых событий по кошелькам в рамках вашей организации, которые система доставляет в виде HTTP-запросов на URL-адреса созданных вами webhook'ов. Обработчики для подобного рода запросов необходимо реализовать на стороне вашего серверного кода согласно данной спецификации.  Webhook — это подписка на определенный тип события либо их группу, касающихся различных объектов в рамках вашей организации. Для управления webhook'ами используются методы API, описанные в спецификации [Vality Webhook Management API](https://github.com/valitydev/swag-wallets). Когда наступает одно из событий в рамках определенного кошелька (например, изменение статуса кошелька), система выбирает webhook, подходящий под этот тип события, и отправляет HTTP-запрос, содержащий сообщение в формате JSON на указанный в этом webhook'е URL. Если вы создали несколько webhook'ов, подходящих под этот тип события, то событие доставляется одновременно на все заданные в них URL в неопределённом порядке.  ## Стратегия доставки  Система гарантирует порядок доставки событий в рамках определенного предмета оповещения (кошелек, пополнение, выплата и т.п.). Система поддерживает очередь сообщений для каждого предмета оповещения, чтобы соблюсти очередность и гарантированную доставку.  Запрос на доставку считается успешным только при получении ответа со статусом `200`. Система будет ожидать успешного ответа на отправленный запрос в течение 10 секунд. В случае ответа любым другим статусом или по истечении указанного времени, отведённого на обработку оповещения, система будет пытаться повторно доставить оповещения до получения успешного ответа, либо до принятия решения о невозможности доставить информацию. Попытки доставки будут производиться со следующими временными интервалами между запросами:    - 30 секунд,   - 5 минут,   - 15 минут,   - 1 час.   - каждый час в течение суток (24 часа)  Если последняя попытка доставить оповещение оканчивается неудачей, все события, которые накопились в очереди этого кошелька, отбрасываются.  ## Авторизация полученных сообщений  Система подтверждает подлинность оповещений, подписывая сообщения приватным ключом, уникальным для каждого webhook'а, парный публичный ключ к которому содержится в данных этого webhook'а. Подпись передается в HTTP-заголовке `Content-Signature`. В заголовке в виде различных атрибутов содержится информация об использованном при формировании подписи алгоритме и значение подписи в формате [URL-safe base-64](https://tools.ietf.org/html/rfc4648).  ``` Content-Signature: alg=RS256; digest=zFuf7bRH4RHwyktaqHQwmX5rn3LfSb4dKo... ```  На данный момент возможно использование единственного алоритма формирования подписи.  ### [RS256](https://tools.ietf.org/html/rfc7518#section-3.3)  Подпись формируется согласно алгоритму [RSASSA-PKCS1-v1_5](https://tools.ietf.org/html/rfc3447#section-8.2), на вход которому подаётся результат вычисления хэша сообщения по алгоритму [SHA-256](https://tools.ietf.org/html/rfc6234).  Набор атрибутов заголовка и список возможных алгоритмов формирования подписи в дальнейшем могут быть расширены. 
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package dev.vality.swag.wallets.webhook.events.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.wallets.webhook.events.model.WithdrawalBody;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Данные вывода денежных средств
 */
@ApiModel(description = "Данные вывода денежных средств")
@JsonPropertyOrder({
  Withdrawal.JSON_PROPERTY_ID,
  Withdrawal.JSON_PROPERTY_CREATED_AT,
  Withdrawal.JSON_PROPERTY_DESTINATION,
  Withdrawal.JSON_PROPERTY_BODY,
  Withdrawal.JSON_PROPERTY_METADATA,
  Withdrawal.JSON_PROPERTY_WALLET,
  Withdrawal.JSON_PROPERTY_EXTERNAL_I_D
})
@JsonTypeName("Withdrawal")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-07-20T13:11:55.613404504Z[Etc/UTC]")
public class Withdrawal {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_DESTINATION = "destination";
  private String destination;

  public static final String JSON_PROPERTY_BODY = "body";
  private WithdrawalBody body;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private JsonNullable<Object> metadata = JsonNullable.<Object>of(null);

  public static final String JSON_PROPERTY_WALLET = "wallet";
  private String wallet;

  public static final String JSON_PROPERTY_EXTERNAL_I_D = "externalID";
  private String externalID;

  public Withdrawal() { 
  }

  public Withdrawal id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Идентификатор вывода денежных средств
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "tZ0jUmlsV0", value = "Идентификатор вывода денежных средств")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public Withdrawal createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Дата и время запуска вывода
   * @return createdAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Дата и время запуска вывода")
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public Withdrawal destination(String destination) {
    
    this.destination = destination;
    return this;
  }

   /**
   * Идентификатор места назначения денежных средств
   * @return destination
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "10ASF74D98", required = true, value = "Идентификатор места назначения денежных средств")
  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDestination() {
    return destination;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDestination(String destination) {
    this.destination = destination;
  }


  public Withdrawal body(WithdrawalBody body) {
    
    this.body = body;
    return this;
  }

   /**
   * Get body
   * @return body
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public WithdrawalBody getBody() {
    return body;
  }


  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBody(WithdrawalBody body) {
    this.body = body;
  }


  public Withdrawal metadata(Object metadata) {
    this.metadata = JsonNullable.<Object>of(metadata);
    
    return this;
  }

   /**
   * Произвольный, специфичный для клиента API и непрозрачный для системы набор данных, ассоциированных с данным выводом 
   * @return metadata
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Произвольный, специфичный для клиента API и непрозрачный для системы набор данных, ассоциированных с данным выводом ")
  @JsonIgnore

  public Object getMetadata() {
        return metadata.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Object> getMetadata_JsonNullable() {
    return metadata;
  }
  
  @JsonProperty(JSON_PROPERTY_METADATA)
  public void setMetadata_JsonNullable(JsonNullable<Object> metadata) {
    this.metadata = metadata;
  }

  public void setMetadata(Object metadata) {
    this.metadata = JsonNullable.<Object>of(metadata);
  }


  public Withdrawal wallet(String wallet) {
    
    this.wallet = wallet;
    return this;
  }

   /**
   * Идентификатор кошелька
   * @return wallet
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "10068321", required = true, value = "Идентификатор кошелька")
  @JsonProperty(JSON_PROPERTY_WALLET)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getWallet() {
    return wallet;
  }


  @JsonProperty(JSON_PROPERTY_WALLET)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setWallet(String wallet) {
    this.wallet = wallet;
  }


  public Withdrawal externalID(String externalID) {
    
    this.externalID = externalID;
    return this;
  }

   /**
   * Уникальный идентификатор сущности на вашей стороне.  При указании будет использован для того, чтобы гарантировать идемпотентную обработку операции. 
   * @return externalID
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10036274", value = "Уникальный идентификатор сущности на вашей стороне.  При указании будет использован для того, чтобы гарантировать идемпотентную обработку операции. ")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalID() {
    return externalID;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalID(String externalID) {
    this.externalID = externalID;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Withdrawal withdrawal = (Withdrawal) o;
    return Objects.equals(this.id, withdrawal.id) &&
        Objects.equals(this.createdAt, withdrawal.createdAt) &&
        Objects.equals(this.destination, withdrawal.destination) &&
        Objects.equals(this.body, withdrawal.body) &&
        equalsNullable(this.metadata, withdrawal.metadata) &&
        Objects.equals(this.wallet, withdrawal.wallet) &&
        Objects.equals(this.externalID, withdrawal.externalID);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdAt, destination, body, hashCodeNullable(metadata), wallet, externalID);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Withdrawal {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    destination: ").append(toIndentedString(destination)).append("\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    wallet: ").append(toIndentedString(wallet)).append("\n");
    sb.append("    externalID: ").append(toIndentedString(externalID)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

