package dev.vality.swag.wallets.webhook.events.api;

import dev.vality.swag.wallets.webhook.events.ApiClient;

import dev.vality.swag.wallets.webhook.events.model.Event;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-05-27T05:23:23.593439800Z[Etc/UTC]")
@Component("dev.vality.swag.wallets.webhook.events.api.EventNotificationsApi")
public class EventNotificationsApi {
    private ApiClient apiClient;

    public EventNotificationsApi() {
        this(new ApiClient());
    }

    @Autowired
    public EventNotificationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Оповестить о событии
     * 
     * <p><b>200</b> - Оповещение обработано
     * @param contentSignature Подпись сообщения, сформированная согласно указанным выше правилам  (required)
     * @param event Данные произошедшего в платформе события (required)
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public void notifyWebhookEvent(String contentSignature, Event event) throws RestClientException {
        notifyWebhookEventWithHttpInfo(contentSignature, event);
    }

    /**
     * Оповестить о событии
     * 
     * <p><b>200</b> - Оповещение обработано
     * @param contentSignature Подпись сообщения, сформированная согласно указанным выше правилам  (required)
     * @param event Данные произошедшего в платформе события (required)
     * @return ResponseEntity&lt;Void&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Void> notifyWebhookEventWithHttpInfo(String contentSignature, Event event) throws RestClientException {
        Object postBody = event;
        
        // verify the required parameter 'contentSignature' is set
        if (contentSignature == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'contentSignature' when calling notifyWebhookEvent");
        }
        
        // verify the required parameter 'event' is set
        if (event == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'event' when calling notifyWebhookEvent");
        }
        

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (contentSignature != null)
        headerParams.add("Content-Signature", apiClient.parameterToString(contentSignature));

        final String[] localVarAccepts = {  };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] contentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] {  };

        ParameterizedTypeReference<Void> returnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/webhook", HttpMethod.POST, Collections.<String, Object>emptyMap(), queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, authNames, returnType);
    }
}
